//#region Definitions
//----------------------------------------------------------------------------------
//
// Default category list.
//
//----------------------------------------------------------------------------------
const DefaultCategory =
{
    0: 'NON',     // No categorized. This is a reserved member and must be defined.
    1: 'APP',     // Application
    2: 'SYSTEM',  // System
    3: 'USER',    // User operation
    4: 'UI',      // GUI operation
    5: 'WF',      // Work flow
    6: 'DEVICE',  // Device
    7: 'DEBUG',   // Debug
    8: 'STEP',    // Step
    9: 'EVENT',   // Event
    10: 'COMM',   // Communication port
}
//----------------------------------------------------------------------------------
//
// Custom category list.
//
//----------------------------------------------------------------------------------
const CustomCategory =
{
    0: 'NON',       // No categorized. This is a reserved member and must be defined.
    1: 'My_APP',    // Application
    2: 'My_SYSTEM', // System
    3: 'My_USER',   // User operation
    4: 'My_UI',     // GUI operation
    5: 'My_WF',     // Work flow
    6: 'My_DEVICE', // Device
    7: 'My_DEBUG',  // Debug
    8: 'My_STEP',   // Step
    9: 'My_EVENT',  // Event
    10: 'My_COMM',  // Communication port
}

//----------------------------------------------------------------------------------
//
// Logging severity list.
//
//----------------------------------------------------------------------------------
const Severity =
{
	0: 'NON',		// No setting
	1: 'INFO',		// Information
	2: 'NOTICE',	// Notice
	3: 'WARNING',   // Warning
	4: 'ERR',		// Normal error
	5: 'FATAL',		// Fatal error
}

//----------------------------------------------------------------------------------
//
// Window state of Logging viewer list.
//
//----------------------------------------------------------------------------------
const WindowStates = 
{
	0: 'SHOW_WINDOW_NORMALY',	// Default
	1: 'SHOW_WINDOW_MAXIMIZE',	// Maximum
	2: 'MINIMIZE_IN_TASKBAR',	// Minimize in taskbar
	3: 'HIDE_IN_TASKTRAY',		// Hide in task tray
	4: 'WINDOW_HIDDEN',			// Hidden
}

//----------------------------------------------------------------------------------
//
// Call APIs list.
//
//----------------------------------------------------------------------------------
const CallAPIs = 
{
    // After the server process is started with parameters passed, the client process is started.
    0: 'FTCORE_StartTriggerWithParam',

    // After the server process is started with parameters set during setup, the client process is started.
    1: 'FTCORE_StartTriggerWithSetup'
}

//----------------------------------------------------------------------------------
//
// Server process window topmost state.
//
//----------------------------------------------------------------------------------
const TopmostStates = 
{
    0: 'FALSE',     // Topmost is false.
    1: 'TRUE'       // Topmost is true.
}

//----------------------------------------------------------------------------------
//
// Server connection port.
//
//----------------------------------------------------------------------------------
const DST_URL = 'http://localhost:8000/';

//#endregion Definitions

//#region Window Event
//----------------------------------------------------------------------------------
//
// Window loading.
//
//----------------------------------------------------------------------------------
window.onload = function()
{
    // Server default settings.
    SetInputBoxText('txtServerName', "localhost");
    SetInputBoxText('txtPortNumber', 50500);

    // Select using category types.
    AddButtonClickListener('radUseDefault', radUseDefault_Click);
    AddButtonClickListener('radUseCustom', radUseCustom_Click);

    // Window state combobox
    AddSelectBoxOption('cmbWindowState', WindowStates);

    // Category combobox
    AddSelectBoxOption('cmbCategory', DefaultCategory);

    // Severity combobox
    AddSelectBoxOption('cmbSeverity', Severity);

    // Start/Exit button
    AddButtonClickListener('btnConnect', btnConnect_Click);
    AddButtonClickListener('btnDiscon', btnDisconnect_Click);

    // Window State button
    AddButtonClickListener('btnState', btnState_Click);

    // Send button
    AddButtonClickListener('btnSend', btnSend_Click);
}
//----------------------------------------------------------------------------------
//
// Window unloading.
//
//----------------------------------------------------------------------------------
window.onunload = function()
{
//  const method = 'api=' + 'FTCORE_ExitTrigger';

//  SendRequest(method, null);
}
//#endregion Window Event

//#region Custom category settings
//----------------------------------------------------------------------------------
//
// Use default category.
//
// event   		[IN]	: 
//
//----------------------------------------------------------------------------------
function radUseDefault_Click(event)
{
    if(event.srcElement.checked){
        AddSelectBoxOption('cmbCategory', DefaultCategory);
        let csvstring = '';
        for(let i = 0; i < Object.keys(DefaultCategory).length; i++){
            csvstring += DefaultCategory[i] + ',';
        }
        csvstring = csvstring.substring(0, csvstring.length - 1);
        const method = 'api=' + 'FTCORE_SetCustomCategory';
        const param = 'categories=' + csvstring;
        SendRequest(method, param);
    
        // Note:================================================================
        // The same result can be obtained by running the following instead.
        // const method = 'api=' + 'FTCORE_LoadDefaultCategory';
        // const param = null;
        // SendRequest(method, param);
    }
}
//----------------------------------------------------------------------------------
//
// Use custom category.
//
// event   		[IN]	: 
//
//----------------------------------------------------------------------------------
function radUseCustom_Click(event)
{
    if(event.srcElement.checked){
        AddSelectBoxOption('cmbCategory', CustomCategory);
        let csvstring = '';
        for(let i = 0; i < Object.keys(CustomCategory).length; i++){
            csvstring += CustomCategory[i] + ',';
        }
        csvstring = csvstring.substring(0, csvstring.length - 1);
        const method = 'api=' + 'FTCORE_SetCustomCategory';
        const param = 'categories=' + csvstring;
        SendRequest(method, param);
    }
}
//#endregon Custom category settings

//#region Server Program Connection Settings
//----------------------------------------------------------------------------------
//
// The client process is started. Server process should be started in advance.
//
// event   		[IN]	: 
//
//----------------------------------------------------------------------------------
function btnConnect_Click(event)
{
    const server = GetInputBoxText('txtServerName');
    const port = GetInputBoxText('txtPortNumber');

    const method = 'api=' + 'FTCORE_StartProcess';
    const param = 'server=' + server + '&' + 
                  'port=' + port;

    SendRequest(method, param);
}

//----------------------------------------------------------------------------------
//
// The client process is exited.
//
// event   		[IN]	: 
//
//----------------------------------------------------------------------------------
function btnDisconnect_Click(event)
{
    const method = 'api=' + 'FTCORE_ExitProcess';

    SendRequest(method, null);
}
//#endregion Server Program Startup Settings

//#region Window state Change
//----------------------------------------------------------------------------------
//
// Change Server program window state.
//
// event   		[IN]	: 
//
//----------------------------------------------------------------------------------
function btnState_Click(event)
{
    // Window state
    var state = GetSelectBoxIndex('cmbWindowState');

    const method = 'api=' + 'FTCORE_SetWindowState';
    const param = 'state=' + state;

    SendRequest(method, param);
}
//#endregion Window state Change

//#region Logging Message Output
//----------------------------------------------------------------------------------
//
// Send logging message.
//
// event   		[IN]	: 
//
//----------------------------------------------------------------------------------
function btnSend_Click(event)
{
    // Get call stack.
    const path = GetStackFrame(2);

    // Category
    var category = GetSelectBoxOption('cmbCategory');
    if(GetCheckBoxState('chkCatRandom'))
    {
        let selected = '';
        if(GetRadioState('radUseDefault')) selected = DefaultCategory;
        else selected = CustomCategory;
        const index = Math.floor(Math.random() * (Object.keys(selected).length));
        category = selected[index];
    }

    // Severity
    var severity = GetSelectBoxOption('cmbSeverity');
    if(GetCheckBoxState('chkSevRandom'))
    {
        const index = Math.floor(Math.random() * (Object.keys(Severity).length));
        severity = Severity[index];
    }

    // Logging message
    const message = GetInputBoxText('txtMessage');

    // Call Logging Foot API
    const method = 'api=' + 'FTCORE_SendMessage';
    const param = 'path=' + path + '&' +
                  'category=' + category + '&' +
                  'severity=' + severity + '&' +
                  'message=' + message;

    SendRequest(method, param);
}
//#endregion Logging Message Output

//#region Utilities
//----------------------------------------------------------------------------------
//
// Send message to server.
//
// method  		[IN]	: API name.
// param        [IN]    : API parameter.
//
//----------------------------------------------------------------------------------
function SendRequest(method, param)
{
    let arg = method;
    if(param != null) arg += '&' + param;

    const xhr = new XMLHttpRequest();
    xhr.open('POST', DST_URL, true);
    xhr.setRequestHeader('content-type', 'application/x-www-form-urlencoded;charset=UTF-8');
    xhr.send(arg);
    console.log(xhr.readyState);
}

//----------------------------------------------------------------------------------
//
// Add items to Select box.
//
// id   		[IN]	: Id of select box in html.
// array		[IN]	: enum array list.
//
//----------------------------------------------------------------------------------
function AddSelectBoxOption(id, array)
{
    const selectbox = document.getElementById(id);
    while(selectbox.children.length > 0){
        selectbox.removeChild(selectbox.firstChild);
    }
    for(let i in array)
    {
        let op = document.createElement('option');
        op.text = array[i];
        selectbox.appendChild(op);
    }
}
//----------------------------------------------------------------------------------
//
// Get item selected in select box.
//
// id   		[IN]	: Id of select box in html.
//
//----------------------------------------------------------------------------------
function GetSelectBoxOption(id)
{
    const selectbox = document.getElementById(id);
    return selectbox.value;
}

//----------------------------------------------------------------------------------
//
// Get index selected in select box.
//
// id   		[IN]	: Id of select box in html.
//
//----------------------------------------------------------------------------------
function GetSelectBoxIndex(id)
{
    const selectbox = document.getElementById(id);
    return selectbox.selectedIndex;
}

//----------------------------------------------------------------------------------
//
// Set text to input box.
//
// id   		[IN]	: Id of input box in html.
// text		    [IN]	: text.
//
//----------------------------------------------------------------------------------
function SetInputBoxText(id, text)
{
    const inputbox = document.getElementById(id);
    inputbox.value = text;
}
//----------------------------------------------------------------------------------
//
// get text from input box.
//
// id   		[IN]	: Id of input box in html.
//
//----------------------------------------------------------------------------------
function GetInputBoxText(id)
{
    const inputbox = document.getElementById(id);
    return inputbox.value;
}

//----------------------------------------------------------------------------------
//
// get state of check box.
//
// id   		[IN]	: Id of check box in html.
//
//----------------------------------------------------------------------------------
function GetCheckBoxState(id)
{
    const checkbox = document.getElementById(id);
    return checkbox.checked;
}

//----------------------------------------------------------------------------------
//
// get state of radio.
//
// id   		[IN]	: Id of radio in html.
//
//----------------------------------------------------------------------------------
function GetRadioState(id)
{
    const radio = document.getElementById(id);
    return radio.checked;
}

//----------------------------------------------------------------------------------
//
// Add handler of button click.
//
// id   		[IN]	: Id of select box in html.
// array		[IN]	: enum array list.
//
//----------------------------------------------------------------------------------
function AddButtonClickListener(id, func)
{
    const button = document.getElementById(id);
    button.addEventListener('click', func);
}

//----------------------------------------------------------------------------------
//
//Get stack frame information.
//
// depth   		[IN]	: stack frame depth.
//
//----------------------------------------------------------------------------------
function GetStackFrame(depth)
{
    const error = new Error();
    const stack = error.stack || '';
    const lines = stack.split('\n');
    if(lines.length >= depth)
    {
        return lines[depth].trim();
    }
}
//#endregion Utilities
