#pragma once

#include "resource.h"
#include <commctrl.h>

void OnInitDialog(HWND hdlg);
void OnExitDialog(HWND hdlg);

void OnButtonDisconClick(HWND hdlg, int idc);
void OnButtonConnectClick(HWND hdlg, int idc);
void OnButtonSendClick(HWND hdlg, int idc);
void OnButtonStopClick(HWND hdlg, int idc);
void OnButtonStartClick(HWND hdlg, int idc);
void OnCheckRandCategoryClick(HWND hdlg, int idc, bool check);
void OnCheckRandSeverityClick(HWND hdlg, int idc, bool check);
void OnTextChange(HWND hdlg, int idc);

inline void AddComboboxItem(HWND hdlg, int idc, char* item)
{
	::SendMessageA(GetDlgItem(hdlg, idc), CB_ADDSTRING, 0, (LPARAM)item);
	::SendMessageA(GetDlgItem(hdlg, idc), CB_SETCURSEL, 0, 0);
}
inline int GetComboboxItem(HWND hdlg, int idc)
{
	return ::SendMessageA(GetDlgItem(hdlg, idc), CB_GETCURSEL, 0, 0);
}

inline bool GetCheckboxState(HWND hdlg, int idc)
{
	int result = ::SendMessageA(GetDlgItem(hdlg, idc), BM_GETCHECK, 0, 0);
	return result == 0 ? false : true;
}

inline void SetSpinValueRange(HWND hdlg, int idc, int initvalue, int min, int max)
{
	::SendMessageA(GetDlgItem(hdlg, idc), UDM_SETRANGE, 0, (LPARAM)MAKELONG(max, min));
	::SendMessageA(GetDlgItem(hdlg, idc), UDM_SETPOS, 0, (LPARAM)initvalue);
}

inline void SetProgressRange(HWND hdlg, int idc, int min, int max, int step)
{
	::SendMessageA(GetDlgItem(hdlg, idc), PBM_SETRANGE, 0, MAKELPARAM(min, max));
	::SendMessageA(GetDlgItem(hdlg, idc), PBM_SETSTEP, (WPARAM)step, 0);
	::SendMessageA(GetDlgItem(hdlg, idc), PBM_SETPOS, 0, 0);
}
inline void SetProgressValue(HWND hdlg, int idc)
{
	::SendMessageA(GetDlgItem(hdlg, idc), PBM_STEPIT, 0, 0);
}

inline void ClickButton(HWND hdlg, int idc)
{
	switch (idc)
	{
		case IDC_BTN_DISCON:

			OnButtonDisconClick(hdlg, idc);
			break;

		case IDC_BTN_CONNECT:

			OnButtonConnectClick(hdlg, idc);
			break;

		case IDC_BTN_SEND:

			OnButtonSendClick(hdlg, idc);
			break;

		case IDC_BTN_STOP:

			OnButtonStopClick(hdlg, idc);
			break;

		case IDC_BTN_START:

			OnButtonStartClick(hdlg, idc);
			break;

		case IDC_CHK_RND_CATEGORY:
		{
			bool check = GetCheckboxState(hdlg, idc);
			OnCheckRandCategoryClick(hdlg, idc, check);
			break;
		}

		case IDC_CHK_RND_SEVERITY:
		{
			bool check = GetCheckboxState(hdlg, idc);
			OnCheckRandSeverityClick(hdlg, idc, check);
			break;
		}
	}
}

inline void EditTextChange(HWND hdlg, int idc)
{
	if(idc == IDC_TXT_MESSAGE)
		OnTextChange(hdlg, idc);
}