﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Threading.Tasks;
using FTSDK_Wrapper;

namespace Sample_SetWindowState
{
    class Program
    {
        /// <summary>
        /// Default category list.
        /// </summary>
        enum DefaultCategory
        {
            /// <summary>
            /// No categorized
            /// </summary>
            NON,
            /// <summary>
            /// Application
            /// </summary>
            APP,
            /// <summary>
            /// System
            /// </summary>
            SYSTEM,
            /// <summary>
            /// User operation
            /// </summary>
            USER,
            /// <summary>
            /// GUI operation
            /// </summary>
            UI,
            /// <summary>
            /// Work flow
            /// </summary>
            WF,
            /// <summary>
            /// Device
            /// </summary>
            DEVICE,
            /// <summary>
            /// Debug
            /// </summary>
            DEBUG,
            /// <summary>
            /// Step
            /// </summary>
            STEP,
            /// <summary>
            /// Event
            /// </summary>
            EVENT,
            /// <summary>
            /// Communication port
            /// </summary>
            COMM,
        }

        /// <summary>
        /// Logging severity list.
        /// </summary>
        enum Severity
        {
            /// <summary>
            /// No setting
            /// </summary>
            NON,
            /// <summary>
            /// Information
            /// </summary>
            INFO,
            /// <summary>
            /// Notice
            /// </summary>
            NOTICE,
            /// <summary>
            /// Warning
            /// </summary>
            WARNING,
            /// <summary>
            /// Normal error
            /// </summary>
            ERROR,
            /// <summary>
            /// Fatal error
            /// </summary>
            FATAL,
        }

        /// <summary>
        /// LoggingFoot sample program.
        /// How to use FTCORE_StartProcess and FTCORE_SetWindowState.
        /// </summary>
        static void Main()
        {
            // Get assembly information.
            var copyright = ProductCopyright;
            var version = FtsdkVersion;

            Console.WriteLine("**********************************************************************");
            Console.WriteLine("");
            Console.WriteLine("  LoggingFoot FTSDK sample program.");
            Console.WriteLine("  How to use FTCORE_StartProcess and FTCORE_SetWindowState.");
            Console.WriteLine("");
            Console.WriteLine($"  {copyright}");
            Console.WriteLine("");
            Console.WriteLine($"                                                  FTSDK ver.{version}");
            Console.WriteLine("**********************************************************************");
            Console.WriteLine("");
            Console.WriteLine("First, Please start Logging server.");
            Console.WriteLine("And next, press any key. (Press Esc key to exit this program.)");
            Console.WriteLine("Logging client will start.");
            Console.WriteLine("");

            // Destination server information.
            var server = "localhost";
            var port = 50500;

            // API execution result.
            var result = FtsdkCSWrapper.FTCORE_RESULT.FTCORE_UNKNOWN_STATE;

            // Wait for key input.
            var keyinfo = new ConsoleKeyInfo();
            Console.WriteLine("> Wait for any key to be pressed ...");
            Console.Write("> ");
            keyinfo = Console.ReadKey();
            Console.WriteLine("");
            Console.WriteLine(System.String.Format("> {0} key was pressed.", keyinfo.Key));
            switch (keyinfo.Key)
            {
                //- Exit program -//
                case ConsoleKey.Escape:
                    break;

                //- Startup Logging Client -//
                default:

                    // Logging Client process start.
                    Console.WriteLine("> Called FTCORE_StartProcess()..");
                    result = FtsdkCSWrapper.FTCORE_StartProcess(server, port);

                    Console.WriteLine("> result: {0}", result);
                    Console.WriteLine("");
                    break;
            }

            if (result == FtsdkCSWrapper.FTCORE_RESULT.FTCORE_SUCCESS)
            {
                //- Select window state -//

                Console.WriteLine("> Press following number key, change window state.");
                Console.WriteLine("> 0 : Default.");
                Console.WriteLine("> 1 : Maximized.");
                Console.WriteLine("> 2 : Minimized to the taskbar.");
                Console.WriteLine("> 3 : Hidden in the system tray.");
                Console.WriteLine("> 4 : Fully hidden.");
                Console.WriteLine("");

                keyinfo = new ConsoleKeyInfo();
                while (keyinfo.Key != ConsoleKey.Escape)
                {
                    //- Log out input keys -//

                    Console.Write("> ");
                    keyinfo = Console.ReadKey();
                    Console.Write(" key was pressed.");
                    Console.WriteLine("");
                    var logmsg = string.Format("{0} key was pressed.", keyinfo.Key.ToString());
                    OutputLog(logmsg);

                    //- Call FTCORE_SetWindowState API -//

                    switch (keyinfo.Key)
                    {
                        case ConsoleKey.NumPad0:
                        case ConsoleKey.D0:

                            // Display in a window with defaultsize.
                            Console.WriteLine("> Called FTCORE_SetWindowState(0)..");
                            result = FtsdkCSWrapper.FTCORE_SetWindowState(0);

                            Console.WriteLine("> result: {0}", result);
                            Console.WriteLine("");
                            break;

                        case ConsoleKey.NumPad1:
                        case ConsoleKey.D1:

                            // Display in maximized window.
                            Console.WriteLine("> Called FTCORE_SetWindowState(1)..");
                            result = FtsdkCSWrapper.FTCORE_SetWindowState(1);

                            Console.WriteLine("> result: {0}", result);
                            Console.WriteLine("");
                            break;

                        case ConsoleKey.NumPad2:
                        case ConsoleKey.D2:

                            // Minimized to the taskbar.
                            Console.WriteLine("> Called FTCORE_SetWindowState(2)..");
                            result = FtsdkCSWrapper.FTCORE_SetWindowState(2);

                            Console.WriteLine("> result: {0}", result);
                            Console.WriteLine("");
                            break;

                        case ConsoleKey.NumPad3:
                        case ConsoleKey.D3:

                            // Hidden in the system tray.
                            Console.WriteLine("> Called FTCORE_SetWindowState(3)..");
                            result = FtsdkCSWrapper.FTCORE_SetWindowState(3);

                            Console.WriteLine("> result: {0}", result);
                            Console.WriteLine("");
                            break;

                        case ConsoleKey.NumPad4:
                        case ConsoleKey.D4:

                            // Fully hidden.
                            Console.WriteLine("> Called FTCORE_SetWindowState(4)..");
                            result = FtsdkCSWrapper.FTCORE_SetWindowState(4);

                            Console.WriteLine("> result: {0}", result);
                            Console.WriteLine("");
                            break;

                        case ConsoleKey.Escape:

                            // Logging Client process exit.
                            Console.WriteLine("> Called FTCORE_ExitProcess()..");
                            result = FtsdkCSWrapper.FTCORE_ExitProcess();

                            Console.WriteLine("> result: {0}", result);
                            Console.WriteLine("");
                            break;
                    }
                }
            }

            // Press any key to exit program.
            Console.WriteLine("Press any key again to exit program.");
            Console.ReadKey();
        }

        /// <summary>
        /// Log output.
        /// </summary>
        /// <param name="message">Content of message.</param>
        static void OutputLog(string message)
        {
            // Random number generator.
            var rand = new System.Random((int)System.DateTime.Now.Ticks);
            var index = 0;

            // Get caller method.
            var stack = new System.Diagnostics.StackFrame(1);
            var path = stack.GetMethod().ToString();

            // Get log categories at random
            var categories = System.Enum.GetNames(typeof(DefaultCategory));
            index = rand.Next() % categories.Length;
            var category = categories[index];

            // Get log severity at random.
            var severities = System.Enum.GetNames(typeof(Severity));
            index = rand.Next() % severities.Length;
            var severity = severities[index];

            // API execution
            Console.WriteLine("> Called FTCORE_SendMessage(...)");
            var result = FtsdkCSWrapper.FTCORE_SendMessage(path, category, severity, message);
            Console.WriteLine("> result: {0}\n", result);
        }

        /// <summary>
        /// Get product copyright information.
        /// </summary>
        static System.String ProductCopyright
        {
            get
            {
                var assyname = System.Reflection.Assembly.GetExecutingAssembly().Location;
                return System.Diagnostics.FileVersionInfo.GetVersionInfo(assyname).LegalCopyright;
            }
        }

        /// <summary>
        /// Get FTSDK version information.
        /// </summary>
        static System.String FtsdkVersion
        {
            get
            {
                var filename = AppDomain.CurrentDomain.BaseDirectory + "ft_cli.dll";
                var version = FileVersionInfo.GetVersionInfo(filename).FileVersion;
                return version;
            }
        }
    }
}
