//#region Definitions
//----------------------------------------------------------------------------------
//
// Default category list.
//
//----------------------------------------------------------------------------------
const DefaultCategory =
{
    0: 'NON',     // No categorized
    1: 'APP',     // Application
    2: 'SYSTEM',  // System
    3: 'USER',    // User operation
    4: 'UI',      // GUI operation
    5: 'WF',      // Work flow
    6: 'DEVICE',  // Device
    7: 'DEBUG',   // Debug
    8: 'STEP',    // Step
    9: 'EVENT',   // Event
    10: 'COMM',   // Communication port
}

//----------------------------------------------------------------------------------
//
// Logging severity list.
//
//----------------------------------------------------------------------------------
const Severity =
{
	0: 'NON',		// No setting
	1: 'INFO',		// Information
	2: 'NOTICE',	// Notice
	3: 'WARNING',   // Warning
	4: 'ERR',		// Normal error
	5: 'FATAL',		// Fatal error
}

//----------------------------------------------------------------------------------
//
// Window state of Logging viewer list.
//
//----------------------------------------------------------------------------------
const WindowStates = 
{
	0: 'SHOW_WINDOW_NORMALY',	// Default
	1: 'SHOW_WINDOW_MAXIMIZE',	// Maximum
	2: 'MINIMIZE_IN_TASKBAR',	// Minimize in taskbar
	3: 'HIDE_IN_TASKTRAY',		// Hide in task tray
	4: 'WINDOW_HIDDEN',			// Hidden
}

//----------------------------------------------------------------------------------
//
// Call APIs list.
//
//----------------------------------------------------------------------------------
const CallAPIs = 
{
    // After the server process is started with parameters passed, the client process is started.
    0: 'FTCORE_StartTriggerWithParam',

    // After the server process is started with parameters set during setup, the client process is started.
    1: 'FTCORE_StartTriggerWithSetup'
}

//----------------------------------------------------------------------------------
//
// Server process window topmost state.
//
//----------------------------------------------------------------------------------
const TopmostStates = 
{
    0: 'FALSE',     // Topmost is false.
    1: 'TRUE'       // Topmost is true.
}

//----------------------------------------------------------------------------------
//
// Server connection port.
//
//----------------------------------------------------------------------------------
const DST_URL = 'http://localhost:8000/';

//#endregion Definitions

//#region Window Event
//----------------------------------------------------------------------------------
//
// Window loading.
//
//----------------------------------------------------------------------------------
window.onload = function()
{
    // Server default settings.
    SetInputBoxText('txtServerName', "localhost");
    SetInputBoxText('txtPortNumber', 50500);
    SetInputBoxText('txtServerPath', "../../../../ftviewer/ft_viewer.exe");
    
    // Call API combobox
    AddSelectBoxOption('cmbCallAPI', CallAPIs);

    // Window state combobox
    AddSelectBoxOption('cmbWindowState', WindowStates);

    // Category combobox
    AddSelectBoxOption('cmbCategory', DefaultCategory);

    // Severity combobox
    AddSelectBoxOption('cmbSeverity', Severity);

    // Topmost combobox
    AddSelectBoxOption('cmbTopmost', TopmostStates);
    
    // // Server path button
    // AddButtonClickListener('btnServerPath', btnServerPath_Click);

    // Start/Exit button
    AddButtonClickListener('btnStartup', btnStartup_Click);
    AddButtonClickListener('btnExit', btnExit_Click);

    // Send button
    AddButtonClickListener('btnSend', btnSend_Click);
}
//----------------------------------------------------------------------------------
//
// Window unloading.
//
//----------------------------------------------------------------------------------
window.onunload = function()
{
    // const method = 'api=' + 'FTCORE_ExitTrigger';

    // SendRequest(method, null);
}
//#endregion Window Event

//#region Server Program Startup Settings
//----------------------------------------------------------------------------------
//
// Select LoggingFootViewer.exe file. Not used.
//
// event   		[IN]	: 
//
//----------------------------------------------------------------------------------
// async function btnServerPath_Click(event)
// {
//     const options = {
//     types: [
//         {
//             description: "Server program",
//             accept: {
//                 "application/octet-stream ": [".exe"],
//             },
//         },
//     ],
//     };

//     const [handle] = await window.showOpenFilePicker(options);
//     const file = await handle.getFile();
//     const refpath = await directoryhandle
//     const filename = await file.name;
//     SetInputBoxText('txtServerPath', filename);
// }

//----------------------------------------------------------------------------------
//
// After the server process is started, the client process is started.
//
// event   		[IN]	: 
//
//----------------------------------------------------------------------------------
function btnStartup_Click(event)
{
    const path = GetInputBoxText('txtServerPath');
    const server = GetInputBoxText('txtServerName');
    const port = GetInputBoxText('txtPortNumber');
    const state = GetSelectBoxOption('cmbWindowState');
    const topmost = GetSelectBoxOption('cmbTopmost');
    const api = GetSelectBoxOption('cmbCallAPI');

    const method = 'api=' + api;
    const param = 'path=' + path + '&'+ 
                  'server=' + server + '&' + 
                  'port=' + port + '&' + 
                  'state=' + state + '&' + 
                  'topmost=' + topmost;

    SendRequest(method, param);
}

//----------------------------------------------------------------------------------
//
// After the server process is exited, the client process is exited.
// Started by FTCORE_StartTriggerWithParam() or FTCORE_StartTriggerWithSetup().
// If there is no server process to exit, only the client process is exited. 
//
// event   		[IN]	: 
//
//----------------------------------------------------------------------------------
function btnExit_Click(event)
{
    const method = 'api=' + 'FTCORE_ExitTrigger';

    SendRequest(method, null);
}
//#endregion Server Program Startup Settings

//#region Logging Message Output
//----------------------------------------------------------------------------------
//
// Send logging message.
//
// event   		[IN]	: 
//
//----------------------------------------------------------------------------------
function btnSend_Click(event)
{
    // Get call stack.
    const path = GetStackFrame(2);

    // Category
    var category = GetSelectBoxOption('cmbCategory');
    if(GetCheckBoxState('chkCatRandom'))
    {
        const index = Math.floor(Math.random() * (Object.keys(DefaultCategory).length));
        category = DefaultCategory[index];
    }

    // Severity
    var severity = GetSelectBoxOption('cmbSeverity');
    if(GetCheckBoxState('chkSevRandom'))
    {
        const index = Math.floor(Math.random() * (Object.keys(Severity).length));
        severity = Severity[index];
    }

    // Logging message
    const message = GetInputBoxText('txtMessage');

    // Call Logging Foot API
    const method = 'api=' + 'FTCORE_SendMessage';
    const param = 'path=' + path + '&' +
                  'category=' + category + '&' +
                  'severity=' + severity + '&' +
                  'message=' + message;

    SendRequest(method, param);
}
//#endregion Logging Message Output

//#region Utilities
//----------------------------------------------------------------------------------
//
// Send message to server.
//
// method  		[IN]	: API name.
// param        [IN]    : API parameter.
//
//----------------------------------------------------------------------------------
function SendRequest(method, param)
{
    let arg = method;
    if(param != null) arg += '&' + param;

    const xhr = new XMLHttpRequest();
    xhr.open('POST', DST_URL, true);
    xhr.setRequestHeader('content-type', 'application/x-www-form-urlencoded;charset=UTF-8');
    xhr.send(arg);
    console.log(xhr.readyState);
}

//----------------------------------------------------------------------------------
//
// Add items to Select box.
//
// id   		[IN]	: Id of select box in html.
// array		[IN]	: enum array list.
//
//----------------------------------------------------------------------------------
function AddSelectBoxOption(id, array)
{
    const selectbox = document.getElementById(id);
    for(let i in array)
    {
        let op = document.createElement('option');
        op.text = array[i];
        selectbox.appendChild(op);
    }
}
//----------------------------------------------------------------------------------
//
// Get item selected in select box.
//
// id   		[IN]	: Id of select box in html.
//
//----------------------------------------------------------------------------------
function GetSelectBoxOption(id)
{
    const selectbox = document.getElementById(id);
    return selectbox.value;
}

//----------------------------------------------------------------------------------
//
// Set text to input box.
//
// id   		[IN]	: Id of input box in html.
// text		    [IN]	: text.
//
//----------------------------------------------------------------------------------
function SetInputBoxText(id, text)
{
    const inputbox = document.getElementById(id);
    inputbox.value = text;
}
//----------------------------------------------------------------------------------
//
// get text from input box.
//
// id   		[IN]	: Id of input box in html.
//
//----------------------------------------------------------------------------------
function GetInputBoxText(id)
{
    const inputbox = document.getElementById(id);
    return inputbox.value;
}

//----------------------------------------------------------------------------------
//
// get state of check box.
//
// id   		[IN]	: Id of check box in html.
//
//----------------------------------------------------------------------------------
function GetCheckBoxState(id)
{
    const checkbox = document.getElementById(id);
    return checkbox.checked;
}

//----------------------------------------------------------------------------------
//
// Add handler of button click.
//
// id   		[IN]	: Id of select box in html.
// array		[IN]	: enum array list.
//
//----------------------------------------------------------------------------------
function AddButtonClickListener(id, func)
{
    const button = document.getElementById(id);
    button.addEventListener('click', func);
}

//----------------------------------------------------------------------------------
//
//Get stack frame information.
//
// depth   		[IN]	: stack frame depth.
//
//----------------------------------------------------------------------------------
function GetStackFrame(depth)
{
    const error = new Error();
    const stack = error.stack || '';
    const lines = stack.split('\n');
    if(lines.length >= depth)
    {
        return lines[depth].trim();
    }
}
//#endregion Utilities
