//----------------------------------------------------------------------------------------------
// C++ wrapper for the LoggingFoot FTSDK.
//
// Copyright © 2025 Quantyworks Software
//----------------------------------------------------------------------------------------------
#pragma once
#include <iostream>
#include <locale>
#include <string>

// LoggingFoot FTSDKWrapper
class FTSDKWrapper
{
public:
    //-----------------------------------------------------------------------------------------------------------------------------
    // LoggingFoot FTSDK APIs for C++ Wrapper Layer.
    //-----------------------------------------------------------------------------------------------------------------------------
    int ftcore_StartProcess(std::string servername, unsigned short portnumber);
    int ftcore_StartTriggerWithParam(std::string serverpath, std::string servername, unsigned short portnumber, int viewstate, int topmost);
    int ftcore_StartTriggerWithSetup(std::string serverpath, std::string servername, unsigned short portnumber);
    int ftcore_ExitProcess();
    int ftcore_ExitTrigger();
    int ftcore_SendMessage(std::string path, std::string category, std::string severity, std::string message);
    int ftcore_SetWindowState(int state);
    int ftcore_LoadDefaultCategory();
    int ftcore_SetCustomCategory(std::string categories);
    int ftcore_SetCustomCategoryFromFile(std::string filename);

private:
    //-----------------------------------------------------------------------------------------------------------------------------
    // LoggingFoot FTSDK C++ Wrapper Layer. 
    //
    // Converts std::string to char code.
    //
    //
    // src				(IN)		: Target string.
    // delimiter		(IN)		: Character of delimiter.
    // numarray			(IN)		: Buffer to store char code.
    //-----------------------------------------------------------------------------------------------------------------------------
    inline void _convertCsvToNum(std::string src, char delimiter, char* numarray)
    {
        int head = 0;
        int tail = src.find_first_of(delimiter);
        int pos = 0;
        while (head < src.size())
        {
            std::string sub(src, head, tail - head);
            numarray[pos] = (unsigned char)std::stoi(sub);

            head = tail + 1;
            tail = src.find_first_of(delimiter, head);
            pos++;

            if (tail == std::string::npos) tail = src.size();
        }
    }

    //-----------------------------------------------------------------------------------------------------------------------------
    // LoggingFoot FTSDK C++ Wrapper Layer. 
    //
    // Convert UTF-8 code point to char string.
    //
    //
    // src				(IN)		: Array containing UTF-8 code points.
    // srcsize  		(IN)		: Length of src array.
    // dst  			(IN)		: Buffer to store char string.
    //-----------------------------------------------------------------------------------------------------------------------------
    inline void _converStringUtf8(const char* src, int srcsize, char* dst)
    {
        setlocale(LC_ALL, "");

        const int _stepbyte1 = 1;
        const int _stepbyte2 = 2;
        const int _stepbyte3 = 3;
        const int _stepbyte4 = 4;

        int result = 0;
        int srcpos = 0;
        int dstpos = 0;
        while (srcpos < srcsize)
        {
            result = 0;
            int cnvbyte = 0;
            int cp = 0;
            int cp1, cp2, cp3, cp4, cp5, cp6;
            unsigned char hp = (unsigned char)*(src + srcpos);

            if (hp >= 0x00 && hp <= 0x7F)
            {
                // 1byte UTF-8
                cp = *(src + srcpos + 0);
                *(dst + dstpos) = cp;

                // next step.
                dstpos += _stepbyte1;
                srcpos += _stepbyte1;
            }
            else if (hp >= 0xC0 && hp <= 0xDF)
            {
                //- src step 2byte -//
                //- dst step 2byte -//

                // mask src code.
                cp1 = (*(src + srcpos + 0) & 0x1C) << 6;
                cp2 = (*(src + srcpos + 0) & 0x03) << 6;
                cp3 = (*(src + srcpos + 1) & 0x3F) << 0;

                // composit code point.
                cp = cp1 + cp2 + cp3;

                // convert to multibyte.
                char mb[_stepbyte2] = {};
                wctomb_s(&result, mb, _stepbyte2, cp);

                // output result.
                for (int i = 0; i < result; i++) 
                    *(dst + dstpos + i) = *(mb + i);

                // next step.
                dstpos += result;
                srcpos += _stepbyte2;
            }
            else if (hp >= 0xE0 && hp <= 0xEF)
            {
                //- src step 3byte -//
                //- dst step 2byte -//

                // mask src code.
                cp1 = (*(src + srcpos + 0) & 0x0F) << 12;
                cp2 = (*(src + srcpos + 1) & 0x30) << 6; 
                cp3 = (*(src + srcpos + 1) & 0x0C) << 6; 
                cp4 = (*(src + srcpos + 1) & 0x03) << 6; 
                cp5 = (*(src + srcpos + 2) & 0x3F) << 0; 

                // composit code point.
                cp = cp1 + cp2 + cp3 + cp4 + cp5;

                // convert to multibyte.
                char mb[_stepbyte2] = {};
                wctomb_s(&result, mb, _stepbyte2, cp);

                // output result.
                for (int i = 0; i < result; i++) 
                    *(dst + dstpos + i) = *(mb + i);

                // next step.
                dstpos += result;
                srcpos += _stepbyte3;
            }
            else if (hp >= 0xF0 && hp <= 0xF7)
            {
                //-- Not supported. --//

                //- src step 4byte -//
                //- dst step 3byte -//

                // mask src code.
                cp1 = (*(src + srcpos + 0) & 0x07) << 18;
                cp2 = (*(src + srcpos + 1) & 0x30) << 12;
                cp3 = (*(src + srcpos + 1) & 0x0F) << 12;
                cp4 = (*(src + srcpos + 2) & 0x3C) << 6;
                cp5 = (*(src + srcpos + 2) & 0x03) << 6;
                cp6 = (*(src + srcpos + 3) & 0x3F) << 0;

                // composit code point.
                cp = cp1 + cp2 + cp3 + cp4 + cp5 + cp6;

                // Not supported.
                char ns = '?';
                for (int i = 0; i < _stepbyte3; i++)
                    *(dst + dstpos + i) = ns;

                // next step.
                dstpos += _stepbyte3;
                srcpos += _stepbyte4;
            }
            else break;
        }
    };
};