//----------------------------------------------------------------------------------------------
// LoggingFoot FTSDK Node.js Proxy Layer.
//
// Usage guide for the LoggingFoot FTSDK in a Node.js Proxy Layer.
//
// Copyright © 2025 Quantyworks Software
//----------------------------------------------------------------------------------------------
#ifndef _PROXY_
#define _PROXY_

#include <napi.h>
#include "../ftsdk_wrapper.h"

class Proxy : public Napi::ObjectWrap<Proxy> {
public:
    static Napi::Object Create(Napi::Env env, const Napi::CallbackInfo& info);
    static Napi::Object Initialize(Napi::Env env, Napi::Object exports);

    Proxy(const Napi::CallbackInfo& info);
    ~Proxy();

    // Function to bind with FTSDKWrapper
    Napi::Value ftcoreStartProcess(const Napi::CallbackInfo &info);
    Napi::Value ftcoreStartTriggerWithParam(const Napi::CallbackInfo &info);
    Napi::Value ftcoreStartTriggerWithSetup(const Napi::CallbackInfo &info);
    Napi::Value ftcoreExitProcess(const Napi::CallbackInfo &info);
    Napi::Value ftcoreExitTrigger(const Napi::CallbackInfo &info);
    Napi::Value ftcoreSendMessage(const Napi::CallbackInfo &info);
    Napi::Value ftcoreSetWindowState(const Napi::CallbackInfo &info);
    Napi::Value ftcoreLoadDefaultCategory(const Napi::CallbackInfo &info);
    Napi::Value ftcoreSetCustomCategory(const Napi::CallbackInfo &info);
    Napi::Value ftcoreSetCustomCategoryFromFile(const Napi::CallbackInfo &info);

private:
    FTSDKWrapper* m_wrapper;
};

#endif