﻿Public Class frmMain

#Region "Definitions"
    ''' <summary>
    ''' Default category list.
    ''' </summary>
    Enum DefaultCategory
        ''' <summary>
        ''' No categorized
        ''' </summary>
        NON
        ''' <summary>
        ''' Application
        ''' </summary>
        APP
        ''' <summary>
        ''' System
        ''' </summary>
        SYSTEM
        ''' <summary>
        ''' User operation
        ''' </summary>
        USER
        ''' <summary>
        ''' GUI operation
        ''' </summary>
        UI
        ''' <summary>
        ''' Work flow
        ''' </summary>
        WF
        ''' <summary>
        ''' Device
        ''' </summary>
        DEVICE
        ''' <summary>
        ''' Debug
        ''' </summary>
        DEBUG
        ''' <summary>
        ''' Step
        ''' </summary>
        STEPLOG
        ''' <summary>
        ''' Event
        ''' </summary>
        EVENTLOG
        ''' <summary>
        ''' Communication port
        ''' </summary>
        COMM
    End Enum

    ''' <summary>
    ''' Logging severity list.
    ''' </summary>
    Enum Severity
        ''' <summary>
        ''' No setting
        ''' </summary>
        NON
        ''' <summary>
        ''' Information
        ''' </summary>
        INFO
        ''' <summary>
        ''' Notice
        ''' </summary>
        NOTICE
        ''' <summary>
        ''' Warning
        ''' </summary>
        WARNING
        ''' <summary>
        ''' Normal error
        ''' </summary>
        ONERROR
        ''' <summary>
        ''' Fatal error
        ''' </summary>
        FATAL
    End Enum

    ''' <summary>
    ''' Window state of Logging viewer list.
    ''' </summary>
    Enum WindowStates

        ''' <summary>
        ''' Default
        ''' </summary>
        SHOW_WINDOW_NORMALY
        ''' <summary>
        ''' Maximized
        ''' </summary>
        SHOW_WINDOW_MAXIMIZE
        ''' <summary>
        ''' Minimized to the taskbar
        ''' </summary>
        MINIMIZE_IN_TASKBAR
        ''' <summary>
        ''' Hidden in the system tray
        ''' </summary>
        HIDE_IN_TASKTRAY
        ''' <summary>
        ''' Fully hidden
        ''' </summary>
        WINDOW_HIDDEN

    End Enum

    ''' <summary>
    ''' Call APIs list.
    ''' </summary>
    Enum CallAPIs

        ''' <summary>
        ''' After the server process Is started with parameters passed, the client process Is started.
        ''' </summary>
        FTCORE_StartTriggerWithParam
        ''' <summary>
        ''' After the server process Is started with parameters set during setup, the client process Is started.
        ''' </summary>
        FTCORE_StartTriggerWithSetup

    End Enum

    ''' <summary>
    ''' Server process window topmost state.
    ''' </summary>
    Enum TopmostState

        ''' <summary>
        ''' Topmost Is false.
        ''' </summary>
        FALSE_STATE = 0
        ''' <summary>
        ''' Topmost Is true.
        ''' </summary>
        TRUE_STATE

    End Enum
#End Region 'Definitions

#Region "Constructor"
    ''' <summary>
    ''' Constructor
    ''' </summary>
    Public Sub New()

        InitializeComponent()

        ' Server name
        Me.txtServerName.Text = "localhost"

        ' Portnumber
        Me.txtPortNumber.Text = "50500"

        ' Server path
        Me.txtServerPath.Text = "..\\..\\..\\..\\..\\ftviewer\\ft_viewer.exe"

        ' Call API combobox
        Dim apis = System.Enum.GetNames(GetType(CallAPIs))
        System.Array.ForEach(apis, Sub(item) Me.cmbCallAPI.Items.Add(item))
        Me.cmbCallAPI.SelectedIndex = 0

        ' Window state combobox
        Dim states = System.Enum.GetNames(GetType(WindowStates))
        System.Array.ForEach(states, Sub(item) Me.cmbWindowState.Items.Add(item))
        Me.cmbWindowState.SelectedIndex = 0

        ' Category combobox
        Dim categories = System.Enum.GetNames(GetType(DefaultCategory))
        System.Array.ForEach(categories, Sub(item) Me.cmbCategory.Items.Add(item))
        Me.cmbCategory.SelectedIndex = 0

        ' Severity combobox
        Dim severities = System.Enum.GetNames(GetType(Severity))
        System.Array.ForEach(severities, Sub(item) Me.cmbSeverity.Items.Add(item))
        Me.cmbSeverity.SelectedIndex = 0

        ' Topmost combobox
        Dim topmost = System.Enum.GetNames(GetType(TopmostState))
        System.Array.ForEach(topmost, Sub(item) Me.cmbTopmost.Items.Add(item))
        Me.cmbTopmost.SelectedIndex = 0

        ' Server path button
        AddHandler Me.btnServerPath.Click, AddressOf Me.btnServerPath_Click

        ' Start/Exit button
        AddHandler Me.btnStartup.Click, AddressOf Me.btnStartupServer_Click
        AddHandler Me.btnExit.Click, AddressOf Me.btnExitServer_Click

        ' Send button
        AddHandler Me.btnSend.Click, AddressOf Me.btnSend_Click

        ' Windows Forms Event
        AddHandler Me.Load, AddressOf Me.frmMain_Load
        AddHandler Me.FormClosed, AddressOf Me.frmMain_Closed

    End Sub
#End Region 'Constructor

#Region "Windows Forms Event"
    ''' <summary>
    ''' Form load
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    Private Sub frmMain_Load(ByVal sender As System.Object, ByVal e As System.EventArgs)

        ' Initial state
        Me.setInitialState()

    End Sub

    ''' <summary>
    ''' Disconnect from server and exit logging.
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    Private Sub frmMain_Closed(ByVal sender As System.Object, ByVal e As System.Windows.Forms.FormClosedEventArgs)

        FtsdkVBWrapper.FTCORE_ExitTrigger()

    End Sub
#End Region 'Windows Forms Event

#Region "Windows Forms State"
    ''' <summary>
    ''' GUI button initial state.
    ''' </summary>
    Private Sub setInitialState()

        Me.btnSend.Enabled = False
        Me.btnStartup.Enabled = True
        Me.btnExit.Enabled = False
        Me.pnlServerSettings.Enabled = True

    End Sub

    ''' <summary>
    ''' GUI button idle state.
    ''' </summary>
    Private Sub setIdleState()

        Me.btnSend.Enabled = True
        Me.btnStartup.Enabled = False
        Me.btnExit.Enabled = True
        Me.pnlServerSettings.Enabled = False

    End Sub
#End Region 'Windows Forms State

#Region "Server Program Startup Settings"
    ''' <summary>
    ''' Server Name
    ''' </summary>
    Private ReadOnly Property ServerName As System.String

        Get
            Return Me.txtServerName.Text
        End Get

    End Property
    ''' <summary>
    ''' Port Number
    ''' </summary>
    Private ReadOnly Property PortNumber As Integer

        Get
            Dim defnum = 50500
            Dim number = 0
            If Not Integer.TryParse(Me.txtPortNumber.Text, number) Then
                number = defnum
            End If

            Return number
        End Get

    End Property

    ''' <summary>
    ''' Server program location path
    ''' </summary>
    Private Property ServerPath As String

        Get
            Return Me.txtServerPath.Text
        End Get
        Set(value As String)
            Me.txtServerPath.Text = value
        End Set

    End Property

    ''' <summary>
    ''' Server program window state
    ''' </summary>
    Private ReadOnly Property WindowViewState As Integer

        Get
            Return Me.cmbWindowState.SelectedIndex
        End Get

    End Property

    ''' <summary>
    ''' Selected API from Call APIs List.
    ''' </summary>
    Private ReadOnly Property SelectedAPI As CallAPIs

        Get
            If Me.cmbCallAPI.SelectedIndex = 0 Then
                Return CallAPIs.FTCORE_StartTriggerWithParam
            Else
                Return CallAPIs.FTCORE_StartTriggerWithSetup
            End If
        End Get

    End Property

    ''' <summary>
    ''' Select LoggingFootViewer.exe file.
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    Private Sub btnServerPath_Click(ByVal sender As System.Object, ByVal e As System.EventArgs)

        Dim fd = New System.Windows.Forms.OpenFileDialog()
        fd.Filter = "Server program|*.exe"

        If fd.ShowDialog() = DialogResult.OK Then
            Me.ServerPath = fd.FileName
        End If

    End Sub

    ''' <summary>
    ''' After the server process is started, the client process is started.
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    Private Sub btnStartupServer_Click(ByVal sender As System.Object, ByVal e As System.EventArgs)

        Dim path = Me.ServerPath
        Dim server = Me.ServerName
        Dim port = Me.PortNumber
        Dim state = Me.WindowViewState
        Dim topmost = Me.TopMost
        Dim result = FtsdkVBWrapper.FTCORE_RESULT.FTCORE_SUCCESS

        If Me.SelectedAPI = CallAPIs.FTCORE_StartTriggerWithParam Then
            result = FtsdkVBWrapper.FTCORE_StartTriggerWithParam(path, server, port, state, topmost)
        Else
            result = FtsdkVBWrapper.FTCORE_StartTriggerWithSetup(path, server, port)
        End If

        If result = FtsdkVBWrapper.FTCORE_RESULT.FTCORE_SUCCESS Then
            Me.setIdleState()
        End If
    End Sub

    ''' <summary>
    ''' After the server process is started, the client process is started.
    ''' Started by FTCORE_StartTriggerWithParam() or FTCORE_StartTriggerWithSetup().
    ''' If there is no server process to exit, only the client process is exited.
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    Private Sub btnExitServer_Click(ByVal sender As System.Object, ByVal e As System.EventArgs)

        FtsdkVBWrapper.FTCORE_ExitTrigger()
        Me.setInitialState()

    End Sub
#End Region 'Server Program Startup Settings

#Region "Logging Message Output"
    ''' <summary>
    ''' Category random checked state
    ''' </summary>
    Private ReadOnly Property IsCategoryRandom As String

        Get
            Return Me.chkCategoryRandom.Checked
        End Get

    End Property
    ''' <summary>
    ''' Selected Category
    ''' </summary>
    Private ReadOnly Property SelectedCategory As String

        Get
            If Me.IsCategoryRandom Then
                Dim rand = New System.Random()
                Dim names = System.Enum.GetNames(GetType(DefaultCategory))
                Return names(rand.Next() Mod names.Length)
            Else
                Return Me.cmbCategory.SelectedItem.ToString()
            End If
        End Get

    End Property
    ''' <summary>
    ''' Category Random checkbox
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    Private Sub chkCategoryRandom_Click(ByVal sender As System.Object, ByVal e As System.EventArgs)

        Dim checkbox = CType(sender, System.Windows.Forms.CheckBox)
        Me.cmbCategory.Enabled = Not checkbox.Checked

    End Sub

    ''' <summary>
    ''' Severity random checked state
    ''' </summary>
    Private ReadOnly Property IsSeverityRandom As String

        Get
            Return Me.chkSeverityRandom.Checked
        End Get

    End Property
    ''' <summary>
    ''' Selected Category
    ''' </summary>
    Private ReadOnly Property SelectedSeverity As String

        Get
            If Me.IsSeverityRandom Then
                Dim rand = New System.Random()
                Dim names = System.Enum.GetNames(GetType(Severity))
                Return names(rand.Next() Mod names.Length)
            Else
                Return Me.cmbSeverity.SelectedItem.ToString()
            End If
        End Get

    End Property
    ''' <summary>
    ''' Severity Random checkbox
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    Private Sub chkSeverityRandom_Click(ByVal sender As System.Object, ByVal e As System.EventArgs)

        Dim checkbox = CType(sender, System.Windows.Forms.CheckBox)
        Me.cmbSeverity.Enabled = Not checkbox.Checked

    End Sub

    ''' <summary>
    ''' Logging output message
    ''' </summary>
    Private ReadOnly Property Message As String

        Get
            Return Me.txtMessage.Text
        End Get

    End Property
    ''' <summary>
    ''' Send logging message.
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    Private Sub btnSend_Click(ByVal sender As System.Object, ByVal e As System.EventArgs)

        ' Get call stack.
        Dim stack = New System.Diagnostics.StackFrame(1)
        Dim path = stack.GetMethod().ToString()

        ' Category
        Dim category = Me.SelectedCategory

        ' Severity
        Dim severity = Me.SelectedSeverity

        ' Logging message
        Dim message = Me.Message

        ' Call LoggingFoot API
        Dim result = FtsdkVBWrapper.FTCORE_SendMessage(path, category, severity, message)

    End Sub
#End Region 'Logging Message Output

End Class
