﻿Module Program
    ''' <summary>
    ''' Default category list.
    ''' </summary>
    Enum DefaultCategory
        ''' <summary>
        ''' No categorized
        ''' </summary>
        NON
        ''' <summary>
        ''' Application
        ''' </summary>
        APP
        ''' <summary>
        ''' System
        ''' </summary>
        SYSTEM
        ''' <summary>
        ''' User operation
        ''' </summary>
        USER
        ''' <summary>
        ''' GUI operation
        ''' </summary>
        UI
        ''' <summary>
        ''' Work flow
        ''' </summary>
        WF
        ''' <summary>
        ''' Device
        ''' </summary>
        DEVICE
        ''' <summary>
        ''' Debug
        ''' </summary>
        DEBUG
        ''' <summary>
        ''' Step
        ''' </summary>
        STEPLOG
        ''' <summary>
        ''' Event
        ''' </summary>
        EVENTLOG
        ''' <summary>
        ''' Communication port
        ''' </summary>
        COMM
    End Enum

    ''' <summary>
    ''' Custom category list.
    ''' </summary>
    Enum CustomCategory
        ''' <summary>
        ''' No categorized
        ''' </summary>
        NON
        ''' <summary>
        ''' Application
        ''' </summary>
        C_APP
        ''' <summary>
        ''' System
        ''' </summary>
        C_SYSTEM
        ''' <summary>
        ''' User operation
        ''' </summary>
        C_USER
        ''' <summary>
        ''' GUI operation
        ''' </summary>
        C_UI
        ''' <summary>
        ''' Work flow
        ''' </summary>
        C_WF
        ''' <summary>
        ''' Device
        ''' </summary>
        C_DEVICE
        ''' <summary>
        ''' Debug
        ''' </summary>
        C_DEBUG
        ''' <summary>
        ''' Step
        ''' </summary>
        C_STEPLOG
        ''' <summary>
        ''' Event
        ''' </summary>
        C_EVENTLOG
        ''' <summary>
        ''' Communication port
        ''' </summary>
        COMM
    End Enum

    ''' <summary>
    ''' Custom category list read from file
    ''' </summary>
    Enum FileCustomCategory
        ''' <summary>
        ''' No categorized
        ''' </summary>
        NON
        ''' <summary>
        ''' Application
        ''' </summary>
        F_APP
        ''' <summary>
        ''' System
        ''' </summary>
        F_SYSTEM
        ''' <summary>
        ''' User operation
        ''' </summary>
        F_USER
        ''' <summary>
        ''' GUI operation
        ''' </summary>
        F_UI
        ''' <summary>
        ''' Work flow
        ''' </summary>
        F_WF
        ''' <summary>
        ''' Device
        ''' </summary>
        F_DEVICE
        ''' <summary>
        ''' Debug
        ''' </summary>
        F_DEBUG
        ''' <summary>
        ''' Step
        ''' </summary>
        F_STEPLOG
        ''' <summary>
        ''' Event
        ''' </summary>
        F_EVENTLOG
        ''' <summary>
        ''' Communication port
        ''' </summary>
        COMM
    End Enum

    ''' <summary>
    ''' Logging severity list.
    ''' </summary>
    Enum Severity
        ''' <summary>
        ''' No setting
        ''' </summary>
        NON
        ''' <summary>
        ''' Information
        ''' </summary>
        INFO
        ''' <summary>
        ''' Notice
        ''' </summary>
        NOTICE
        ''' <summary>
        ''' Warning
        ''' </summary>
        WARNING
        ''' <summary>
        ''' Normal error
        ''' </summary>
        ONERROR
        ''' <summary>
        ''' Fatal error
        ''' </summary>
        FATAL
    End Enum

    ''' <summary>
    ''' LoggingFoot sample program.
    ''' How to use FTCORE_StartProcess and FTCORE_SetCustomCategory.
    ''' </summary>
    Sub Main()

        ' Get assembly information.
        Dim copyright = ProductCopyright
        Dim Version = FtsdkVersion

        Console.WriteLine("**********************************************************************")
        Console.WriteLine("")
        Console.WriteLine("  LoggingFoot FTSDK sample program.")
        Console.WriteLine("  How to use FTCORE_StartProcess and FTCORE_SetCustomCategory.")
        Console.WriteLine("")
        Console.WriteLine($"  {copyright}")
        Console.WriteLine("")
        Console.WriteLine($"                                                  FTSDK ver.{Version}")
        Console.WriteLine("**********************************************************************")
        Console.WriteLine("")
        Console.WriteLine("First, Please start Logging server.")
        Console.WriteLine("And next, press any key. (Press Esc key to exit this program.)")
        Console.WriteLine("Logging client will start.")
        Console.WriteLine("")

        ' Destination server information.
        Dim server = "localhost"
        Dim port = 50500

        ' API execution result.
        Dim result = FtsdkVBWrapper.FTCORE_RESULT.FTCORE_UNKNOWN_STATE

        ' Refer to category type
        ' 0: Default category
        ' 1: custom category
        ' 2: custom category read from file
        Dim categorytype = 0

        ' Wait for key input.
        Dim keyinfo = New ConsoleKeyInfo()
        Console.WriteLine("> Wait for any key to be pressed ...")
        Console.Write("> ")
        keyinfo = Console.ReadKey()
        Console.WriteLine("")
        Console.WriteLine(System.String.Format("> {0} key was pressed.", keyinfo.Key))
        Select Case (keyinfo.Key)

                '//- Exit program -//
            Case ConsoleKey.Escape
                Exit Select

                '//- Startup Logging Client -//
            Case Else

                ' Loggin Client process start.
                Console.WriteLine("> Called FTCORE_StartProcess()..")
                result = FtsdkVBWrapper.FTCORE_StartProcess(server, port)

                Console.WriteLine("> result: {0}", result)
                Console.WriteLine("")
                Exit Select
        End Select

        If result = FtsdkVBWrapper.FTCORE_RESULT.FTCORE_SUCCESS Then

            '//- Select custom category setting API -//
            Console.WriteLine("> Press following number key, select API.")
            Console.WriteLine("> 0 : FTCORE_LoadDefaultCategory()")
            Console.WriteLine("> 1 : FTCORE_SetCustomCategory()")
            Console.WriteLine("> 2 : FTCORE_SetCustomCategoryFromFile()")
            Console.WriteLine("")

            keyinfo = New ConsoleKeyInfo()
            While keyinfo.Key <> ConsoleKey.Escape

                Console.Write("> ")
                keyinfo = Console.ReadKey()
                Console.Write(" key was pressed.")
                Console.WriteLine("")
                Dim logmsg = String.Format("{0} key was pressed.", keyinfo.Key.ToString())
                OutputLog(logmsg, categorytype)

                '//- Call FTCORE_SetCustomCategory API -//

                Select Case (keyinfo.Key)
                    Case ConsoleKey.NumPad0, ConsoleKey.D0

                        '// Directs loading of default category that stored in Logging Serever.
                        categorytype = 0
                        Console.WriteLine("> Called FTCORE_LoadDefaultCategory()..")
                        result = FtsdkVBWrapper.FTCORE_LoadDefaultCategory()

                        Console.WriteLine("> result: {0}", result)
                        Console.WriteLine("")
                        Exit Select

                    Case ConsoleKey.NumPad1, ConsoleKey.D1

                        '// Set the category defined in this program to Logging Serever.

                        ' Concatenate category names separated by commas (with or without a comma at the end of the string).
                        categorytype = 1
                        Dim enums = System.Enum.GetNames(GetType(CustomCategory))
                        Dim categories = System.String.Empty
                        System.Array.ForEach(enums, Sub(category) categories += category + (","))

                        ' Set to Logging Server process.
                        Console.WriteLine("> Called FTCORE_SetCustomCategory()..")
                        result = FtsdkVBWrapper.FTCORE_SetCustomCategory(categories)

                        Console.WriteLine("> result: {0}", result)
                        Console.WriteLine("")
                        Exit Select

                    Case ConsoleKey.NumPad2, ConsoleKey.D2

                        '// Read the categories stored in the file and set them to Logging Server.

                        categorytype = 2
                        Dim file = ".\\CustomCategory_Sample.catdef"

                        ' Set to Logging Server process.
                        Console.WriteLine("> Called FTCORE_SetCustomCategoryFromFile()..")
                        result = FtsdkVBWrapper.FTCORE_SetCustomCategoryFromFile(file)

                        Console.WriteLine("> result: {0}", result)
                        Console.WriteLine("")
                        Exit Select

                    Case ConsoleKey.Escape

                        ' Logging Client process exit.
                        Console.WriteLine("> Called FTCORE_ExitProcess()..")
                        result = FtsdkVBWrapper.FTCORE_ExitProcess()

                        Console.WriteLine("> result: {0}", result)
                        Console.WriteLine("")
                        Exit Select
                End Select
            End While
        End If

        ' Press any key to exit program.
        Console.WriteLine("Press any key again to exit program.")
        Console.ReadKey()
    End Sub

    ''' <summary>
    ''' Log output
    ''' </summary>
    ''' <param name="message">Content of message.</param>
    ''' <param name="categorytype">Refer to category type</param>
    Sub OutputLog(message As String, categorytype As Integer)

        ' Random number generator.
        Dim rand = New System.Random()
        Dim index = 0

        ' Get caller method.
        Dim stack = New System.Diagnostics.StackFrame(1)
        Dim path = stack.GetMethod().ToString()

        ' Get log categories at random
        Dim categories As String() = System.Enum.GetNames(GetType(DefaultCategory))
        Select Case (categorytype)
            Case 0
                categories = System.Enum.GetNames(GetType(DefaultCategory))
                Exit Select
            Case 1
                categories = System.Enum.GetNames(GetType(CustomCategory))
                Exit Select
            Case 2
                categories = System.Enum.GetNames(GetType(FileCustomCategory))
                Exit Select
        End Select
        index = rand.Next() Mod categories.Length
        Dim category = categories(index)

        ' Get log severity at random
        Dim severities = System.Enum.GetNames(GetType(Severity))
        index = rand.Next() Mod severities.Length
        Dim severity = severities(index)

        ' API execution
        Console.WriteLine("> Called FTCORE_SendMessage(...)")
        Dim result = FtsdkVBWrapper.FTCORE_SendMessage(path, category, severity, message)
        Console.WriteLine("> result: {0}" + System.Environment.NewLine, result)

    End Sub

    ''' <summary>
    ''' Get product version information.
    ''' </summary>
    ReadOnly Property ProductCopyright As System.String
        Get
            Dim assyname = System.Reflection.Assembly.GetExecutingAssembly().Location
            Return System.Diagnostics.FileVersionInfo.GetVersionInfo(assyname).LegalCopyright
        End Get
    End Property

    ''' <summary>
    ''' Get FTSDK version information.
    ''' </summary>
    ReadOnly Property FtsdkVersion As System.String
        Get
            Dim filename = AppDomain.CurrentDomain.BaseDirectory + "ft_cli.dll"
            Dim version = FileVersionInfo.GetVersionInfo(filename).FileVersion
            Return version
        End Get
    End Property

End Module
