//----------------------------------------------------------------------------------------------
// Sample program for Logging Foot using Node.js
// 
// Copyright © 2025 Quantyworks Software
//----------------------------------------------------------------------------------------------

//----------------------------------------------------------------------------------
//
// Logging Foot FTSDK API Results.
//
//----------------------------------------------------------------------------------
const FTCORE_RESULT = 
{
    0: 'FTCORE_SUCCESS',				    // Operation completed successfully.


	//-- Events --//

	4: 'FTCORE_EVT_CLIENT_DETECTDISCON',    // Client detected a disconnection from the server.
	5: 'FTCORE_EVT_CLIENT_RECEIVED',	    // Client received data from the server.


	//-- Errors --//

	21: 'FTCORE_ERR_CLIENT_NOTSERVER',      // The server is not running or does not exist.
	22: 'FTCORE_ERR_CLIENT_FAILSERVER',     // Failed to start the logging server.

	23: 'FTCORE_ERR_CLIENT_NOEXIST',        // Called before the process was created.
	24: 'FTCORE_ERR_CLIENT_ALREADY',        // The process has already been started.
	25: 'FTCORE_ERR_CLIENT_PARAMETER',      // Invalid parameters were provided.
	26: 'FTCORE_ERR_CLIENT_HOSTINFO',       // Failed to retrieve host information.
	27: 'FTCORE_ERR_CLIENT_SOCKET',         // Failed to create a socket.
	28: 'FTCORE_ERR_CLIENT_REFUSED',        // The target process is not accepting connections or refused the connection.
	29: 'FTCORE_ERR_CLIENT_UNREACHED',      // The network path to the destination is unknown.
	30: 'FTCORE_ERR_CLIENT_CONNECT',        // Connection failed due to an unknown cause.
	31: 'FTCORE_ERR_CLIENT_ESTABLISH',      // An error occurred during the connection establishment process.
	32: 'FTCORE_ERR_CLIENT_MESSAGESEND',    // Failed to send the message.
	33: 'FTCORE_ERR_CLIENT_MESSAGERECV',    // Failed to receive the message.
    34: 'FTCORE_ERR_CLIENT_CONNUNKNOWN',    // Received a connection notification from an unknown server.
}


// To use LoggingFoot FTSDK wrapper layer.
var wrapper = require('./ftsdk_nodejs_sample.js');

var ftresult = FTCORE_RESULT;

console.log("Starting server..");
const PORT_NUMBER = 8000;

// Create web server
const http = require('http');
const server = http.createServer();

// Start web server.
server.on('request', function(req, res)
{
    if(req.method == 'POST')
    {
        let data = "";
        req.on('data', function(chunk){data += chunk}).on('end', function()
        {
            let result = "";
            console.log(data);
            // word[0] : API name
            // word[1]~: Parameter
            const word = data.split('&');
            if(word.length >= 1){
                const api = word[0].split('=')[1];
                let param = [];
                if(word.length >= 2){
                    for(let i = 1; i < word.length; i++){
                        param.push(word[i]);
                    }
                }
                switch(api){
                    case 'FTCORE_StartProcess':

                        // Call FTSDK wrapper layer.
                        result = wrapper.FTCORE_StartProcess(param);
                        console.log("FTCORE_StartProcess Result:" + ftresult[result]);
                        break;

                    case 'FTCORE_ExitProcess':

                        // Call FTSDK wrapper layer.
                        result = wrapper.FTCORE_ExitProcess();
                        console.log("FTCORE_ExitProcess Result:" + ftresult[result]);
                        break;

                    case 'FTCORE_SetWindowState':

                        // Call FTSDK wrapper layer.
                        result = wrapper.FTCORE_SetWindowState(param);
                        console.log("FTCORE_SetWindowState Result:" + ftresult[result]);
                        break;

                    case 'FTCORE_SendMessage':

                        // Call FTSDK wrapper layer.
                        result = wrapper.FTCORE_SendMessage(param);
                        console.log("FTCORE_SendMessage Result:" + ftresult[result]);
                        break;

                    case 'FTCORE_SetCustomCategory':

                        // Call FTSDK wrapper layer.
                        result = wrapper.FTCORE_SetCustomCategory(param);
                        console.log("FTCORE_SetCustomCategory Result:" + ftresult[result]);
                        break;

                    case 'FTCORE_LoadDefaultCategory':

                        // Call FTSDK wrapper layer.
                        result = wrapper.FTCORE_LoadDefaultCategory(param);
                        console.log("FTCORE_LoadDefaultCategory Result:" + ftresult[result]);
                        break;
                }
            }

            res.end();
        })
    }
});

server.listen(PORT_NUMBER, () => {
    console.log("Server running listen port:" + PORT_NUMBER);
});
