#include <iostream>
#include <conio.h>
#include <windows.h>
#include <dbghelp.h>
#include <psapi.h>
#include "framework.h"
#pragma comment(lib, "version.lib")
#pragma comment(lib, "dbghelp.lib")
#pragma comment(lib, "psapi.lib" )

// For GUI Window
#include "DialogWindow.h"

// For using FTSDK
#include "..\FTSDK\h\ftsdk_core.h"

#ifdef _DEBUG
#pragma comment(lib, "..\\ftsdk\\lib\\ft_cli_d.lib")
#pragma comment(lib, "..\\ftsdk\\lib\\ft_rmt_d.lib")
#else
#pragma comment(lib, "..\\ftsdk\\lib\\ft_cli.lib")
#pragma comment(lib, "..\\ftsdk\\lib\\ft_rmt.lib")
#endif


#pragma region Definitions
//----------------------------------------------------------------------------------
//
// Default category list.
//
//----------------------------------------------------------------------------------
enum DefaultCategory
{
	NON,				// No categorized
	APP,				// Application
	SYSTEM,				// System
	USER,				// User operation
	UI,					// GUI operation
	WF,					// Work flow
	DEVICE,				// Device
	DEBUG,				// Debug
	STEP,				// Step
	EVENT,				// Event
	COMM,				// Communication port

	NUMBER_OF_CATEGORY	// Number of category
};

//----------------------------------------------------------------------------------
//
// Logging severity list.
//
//----------------------------------------------------------------------------------
enum Severity
{
	NONE,				// No setting
	INFO,				// Information
	NOTICE,				// Notice
	WARNING,			// Warning
	ERR,				// Normal error
	FATAL,				// Fatal error

	NUMBER_OF_SEVERITY	// Number of severity
};

//----------------------------------------------------------------------------------
//
// Window state of Logging viewer list.
//
//----------------------------------------------------------------------------------
enum WindowStates
{
	SHOW_WINDOW_NORMALY,	// Default
	SHOW_WINDOW_MAXIMIZE,	// Maximized
	MINIMIZE_IN_TASKBAR,	// Minimized to the taskbar
	HIDE_IN_SYSTEMTRAY,		// Hidden in the system tray
	WINDOW_HIDDEN,			// Fully hidden

	NUMBER_OF_WINDOWSTATES	// Number of window state
};

//----------------------------------------------------------------------------------
//
// Call APIs list.
//
//----------------------------------------------------------------------------------
enum CallAPIs
{
	// After the server process is started with parameters passed, the client process is started.
	_FTCORE_StartTriggerWithParam_,

	// After the server process is started with parameters set during setup, the client process is started.
	_FTCORE_StartTriggerWithSetup_,

	// Number of CallAPIs
	NUMBER_OF_CALLAPIS
};

//----------------------------------------------------------------------------------
//
// Server process window topmost state.
//
//----------------------------------------------------------------------------------
enum TopmostStates
{
	STATE_FALSE = 0,	// Topmost is false.
	STATE_TRUE,			// Topmost is true.

	NUMBER_OF_TOPMOSTSTATE	// Number of TopmostState
};
#pragma endregion Definitions

#pragma region Prototype
//----------------------------------------------------------------------------------
//
// Prototype
//
//----------------------------------------------------------------------------------
char* ConvertString(FTCORE_RESULT result, char* buffer);
char* ConvertString(DefaultCategory category, char* buffer);
char* ConvertString(Severity category, char* buffer);
char* ConvertString(TopmostStates state, char* buffer);
char* ConvertString(CallAPIs api, char* buffer);
char* ConvertString(WindowStates state, char* buffer);
void setInitialState(HWND hdlg);
void setIdleState(HWND hdlg);
void setServerSettingState(HWND hdlg, BOOL state);
CallAPIs GetSelectedCallAPI(HWND hdlg);
WindowStates GetSelectedWindowState(HWND hdlg);
char* GetStackFrame(long depth, char* buffer);

#pragma endregion Prototype

#pragma region Dialog Event
//----------------------------------------------------------------------------------
//
// Dialog initialize.
//
// hdlg			[IN]	: Window handle of dialog.
//
//----------------------------------------------------------------------------------
void OnInitDialog(HWND hdlg)
{
	// Window size
	SetWindowPos(hdlg, NULL, 0, 0, 654, 505, (SWP_NOZORDER | SWP_NOOWNERZORDER | SWP_NOMOVE));

	// Server default settings.
	::SetDlgItemTextA(hdlg, IDC_TXT_SERVER_NAME, "localhost");
	::SetDlgItemTextA(hdlg, IDC_TXT_PORT_NUMBER, "50500");
	::SetDlgItemTextA(hdlg, IDC_TXT_SERVER_PATH, "..\\..\\..\\..\\..\\ftviewer\\ft_viewer.exe");

	// Buffer for string convert.
	char buffer[MAX_PATH] = {};

	// Call API combobox
	for (int index = 0; index < CallAPIs::NUMBER_OF_CALLAPIS; index++)
	{
		AddComboboxItem(::GetDlgItem(hdlg, IDC_CMB_CALL_API), ConvertString((CallAPIs)index, buffer));
	}

	// Window state combobox
	for (int index = 0; index < WindowStates::NUMBER_OF_WINDOWSTATES; index++)
	{
		AddComboboxItem(GetDlgItem(hdlg, IDC_CMB_WINDOW_STATE), ConvertString((WindowStates)index, buffer));
	}

	// Category combobox
	for (int index = 0; index < DefaultCategory::NUMBER_OF_CATEGORY; index++)
	{
		AddComboboxItem(GetDlgItem(hdlg, IDC_CMB_CATEGORY), ConvertString((DefaultCategory)index, buffer));
	}

	// Severity combobox
	for (int index = 0; index < Severity::NUMBER_OF_SEVERITY; index++)
	{
		AddComboboxItem(GetDlgItem(hdlg, IDC_CMB_SEVERITY), ConvertString((Severity)index, buffer));
	}

	// Topmost combobox
	for (int index = 0; index < TopmostStates::NUMBER_OF_TOPMOSTSTATE; index++)
	{
		AddComboboxItem(GetDlgItem(hdlg, IDC_CMB_TOPMOST), ConvertString((TopmostStates)index, buffer));
	}

	// Initial state
	setInitialState(hdlg);
}

//----------------------------------------------------------------------------------
//
// Dialog Exiting.
//
// hdlg			[IN]	: Window handle of dialog.
//
//----------------------------------------------------------------------------------
void OnExitDialog(HWND hdlg)
{
	FTCORE_ExitTrigger();
}
#pragma endregion Dialog Event

#pragma region GUI Controls State
//----------------------------------------------------------------------------------
//
// GUI button initial state.
//
// hdlg			[IN]	: Window handle of dialog.
//
//----------------------------------------------------------------------------------
void setInitialState(HWND hdlg)
{
	::EnableWindow(GetDlgItem(hdlg, IDC_BTN_SEND), FALSE);
	::EnableWindow(GetDlgItem(hdlg, IDC_BTN_STARTUP), TRUE);
	::EnableWindow(GetDlgItem(hdlg, IDC_BTN_EXIT), FALSE);
	setServerSettingState(hdlg, TRUE);
}

//----------------------------------------------------------------------------------
//
// GUI button idle state.
//
// hdlg			[IN]	: Window handle of dialog.
//
//----------------------------------------------------------------------------------
void setIdleState(HWND hdlg)
{
	::EnableWindow(GetDlgItem(hdlg, IDC_BTN_SEND), TRUE);
	::EnableWindow(GetDlgItem(hdlg, IDC_BTN_STARTUP), FALSE);
	::EnableWindow(GetDlgItem(hdlg, IDC_BTN_EXIT), TRUE);
	setServerSettingState(hdlg, FALSE);
}

//----------------------------------------------------------------------------------
//
// GUI button group of server program startup settings.
//
// hdlg			[IN]	: Window handle of dialog.
//
//----------------------------------------------------------------------------------
void setServerSettingState(HWND hdlg, BOOL state)
{
	::EnableWindow(GetDlgItem(hdlg, IDC_TXT_SERVER_NAME), state);
	::EnableWindow(GetDlgItem(hdlg, IDC_TXT_SERVER_PATH), state);
	::EnableWindow(GetDlgItem(hdlg, IDC_TXT_PORT_NUMBER), state);
	::EnableWindow(GetDlgItem(hdlg, IDC_BTN_SERVER_PATH), state);
	::EnableWindow(GetDlgItem(hdlg, IDC_CMB_CALL_API), state);
	::EnableWindow(GetDlgItem(hdlg, IDC_CMB_WINDOW_STATE), state);
	::EnableWindow(GetDlgItem(hdlg, IDC_CMB_TOPMOST), state);
}
#pragma endregion GUI Controls State

#pragma region Server Program Startup Settings
//----------------------------------------------------------------------------------
//
// Get selected enum of CallAPIs from combobox.
//
// hdlg			[IN]	: Window handle of dialog.
//
//----------------------------------------------------------------------------------
CallAPIs GetSelectedCallAPI(HWND hdlg)
{
	int index = GetComboboxItem(GetDlgItem(hdlg, IDC_CMB_CALL_API));

	return (CallAPIs)index;
}

//----------------------------------------------------------------------------------
//
// Get selected enum of WindowStates from combobox.
//
// hdlg			[IN]	: Window handle of dialog.
//
//----------------------------------------------------------------------------------
WindowStates GetSelectedWindowState(HWND hdlg)
{
	int index = GetComboboxItem(GetDlgItem(hdlg, IDC_CMB_WINDOW_STATE));

	return (WindowStates)index;
}

//----------------------------------------------------------------------------------
//
// Get selected enum of TopmostStates from combobox.
//
// hdlg			[IN]	: Window handle of dialog.
//
//----------------------------------------------------------------------------------
TopmostStates GetSelectedTopmost(HWND hdlg)
{
	int index = GetComboboxItem(GetDlgItem(hdlg, IDC_CMB_TOPMOST));

	return (TopmostStates)index;
}

//----------------------------------------------------------------------------------
//
// Select ft_viewer.exe file.
//
// hdlg			[IN]	: Window handle of dialog.
// idc			[IN]	: Control ID of this button.(IDC_BTN_SERVER_PATH)
//
//----------------------------------------------------------------------------------
void OnButtonServerPathClick(HWND hdlg, int idc)
{
	wchar_t pfilename[MAX_PATH] = {};
	wchar_t pfiletitle[MAX_PATH] = {};

	// Open file dialog.
	OPENFILENAME ofn;
	ZeroMemory(&ofn, sizeof(OPENFILENAME));
	ofn.lStructSize = sizeof(OPENFILENAME);
	ofn.hwndOwner = hdlg;
	ofn.lpstrFilter = _T("Execution file (*.exe)\0*.exe;\0");
	ofn.nFilterIndex = 1;
	ofn.lpstrFile = pfilename;
	ofn.nMaxFile = MAX_PATH;
	ofn.Flags = OFN_FILEMUSTEXIST | OFN_HIDEREADONLY;
	ofn.lpstrDefExt = _T("");
	ofn.nMaxFileTitle = 64;
	ofn.lpstrFileTitle = pfiletitle;
	ofn.lpstrTitle = NULL;
	::GetOpenFileName(&ofn);	// open.

	if (ofn.lpstrFile[0])
	{
		::SetDlgItemText(hdlg, IDC_TXT_SERVER_PATH, ofn.lpstrFile);
	}
}

//----------------------------------------------------------------------------------
//
// After the server process is started, the client process is started.
//
// hdlg			[IN]	: Window handle of dialog.
// idc			[IN]	: Control ID of this button.(IDC_BTN_STARTUP)
//
//----------------------------------------------------------------------------------
void OnButtonStartupClick(HWND hdlg, int idc)
{
	char path[MAX_PATH]; ::GetDlgItemTextA(hdlg, IDC_TXT_SERVER_PATH, path, MAX_PATH);
	char server[MAX_PATH]; ::GetDlgItemTextA(hdlg, IDC_TXT_SERVER_NAME, server, MAX_PATH);
	int port = ::GetDlgItemInt(hdlg, IDC_TXT_PORT_NUMBER, FALSE, FALSE);
	int state = (int)GetSelectedWindowState(hdlg);
	int topmost = GetSelectedTopmost(hdlg) == TopmostStates::STATE_FALSE ? 0 : 1;
	FTCORE_RESULT result = FTCORE_RESULT::FTCORE_SUCCESS;

	if (GetSelectedCallAPI(hdlg) == CallAPIs::_FTCORE_StartTriggerWithParam_)
		result = FTCORE_StartTriggerWithParam(path, server, (USHORT)port, state, topmost);
	else
		result = FTCORE_StartTriggerWithSetup(path, server, (USHORT)port);

	if (result == FTCORE_RESULT::FTCORE_SUCCESS)
	{
		setIdleState(hdlg);
	}
	else
	{
		setInitialState(hdlg);
	}
}

//----------------------------------------------------------------------------------
//
// After the server process is exited, the client process is exited.
// Started by FTCORE_StartTriggerWithParam() or FTCORE_StartTriggerWithSetup().
// If there is no server process to exit, only the client process is exited.
//
// hdlg			[IN]	: Window handle of dialog.
// idc			[IN]	: Control ID of this button.(IDC_BTN_EXIT)
//
//----------------------------------------------------------------------------------
void OnButtonExitClick(HWND hdlg, int idc)
{
	FTCORE_ExitTrigger();
	setInitialState(hdlg);
}
#pragma endregion Server Program Startup Settings

#pragma region Logging Message Output
//----------------------------------------------------------------------------------
//
// Randomize category selection.
//
// hdlg			[IN]	: Window handle of dialog.
// idc			[IN]	: Control ID of this checkbox.(IDC_CHK_RND_CATEGORY)
// check		[IN]	: Random state (true: random / false: not)
//
//----------------------------------------------------------------------------------
void OnCheckRandCategoryClick(HWND hdlg, int idc, bool check)
{
	BOOL enable = check ? FALSE : TRUE;
	::EnableWindow(GetDlgItem(hdlg, IDC_CMB_CATEGORY), enable);
}

//----------------------------------------------------------------------------------
//
// Randomize severity selection.
//
// hdlg			[IN]	: Window handle of dialog.
// idc			[IN]	: Control ID of this checkbox.(IDC_CHK_RND_SEVERITY)
// check		[IN]	: Random state (true: random / false: not)
//
//----------------------------------------------------------------------------------
void OnCheckRandSeverityClick(HWND hdlg, int idc, bool check)
{
	BOOL enable = check ? FALSE : TRUE;
	::EnableWindow(GetDlgItem(hdlg, IDC_CMB_SEVERITY), enable);
}

//----------------------------------------------------------------------------------
//
// Send logging message.
//
// hdlg			[IN]	: Window handle of dialog.
// idc			[IN]	: Control ID of this button.(IDC_BTN_SEND)
//
//----------------------------------------------------------------------------------
void OnButtonSendClick(HWND hdlg, int idc)
{
	// Index of earch enum;
	int index = 0;

	// Get caller method.
	char path[MAX_PATH] = {};
	GetStackFrame(0, path);

	// Category
	if (GetCheckboxState(GetDlgItem(hdlg, IDC_CHK_RND_CATEGORY))) index = ::rand() % DefaultCategory::NUMBER_OF_CATEGORY;
	else index = GetComboboxItem(GetDlgItem(hdlg, IDC_CMB_CATEGORY));
	char category[MAX_PATH] = {}; ConvertString((DefaultCategory)index, category);

	// Severity
	if (GetCheckboxState(GetDlgItem(hdlg, IDC_CHK_RND_SEVERITY))) index = ::rand() % Severity::NUMBER_OF_SEVERITY;
	else index = GetComboboxItem(GetDlgItem(hdlg, IDC_CMB_SEVERITY));
	char severity[MAX_PATH] = {}; ConvertString((Severity)index, severity);

	// Logging message
	char message[MAX_MESSAGE_SIZE] = {}; GetDlgItemTextA(hdlg, IDC_TXT_MESSAGE, message, MAX_MESSAGE_SIZE);

	// Call LoggingFoot API
	FTCORE_SendMessage(path, category, severity, message);
}
#pragma endregion Logging Message Output

#pragma region Utilities
//----------------------------------------------------------------------------------
//
// Convert FTCORE_RESULT to String.
//
// result		[IN]	: Result of Called FTCORE API.
// buffer		[OUT]	: For return buffer
//
// return				: Pointer of buffer.
//----------------------------------------------------------------------------------
char* ConvertString(FTCORE_RESULT result, char* buffer)
{
	switch (result)
	{
		//-- Sucess --//

	case FTCORE_RESULT::FTCORE_SUCCESS:
		::sprintf_s(buffer, MAX_PATH, "FTCORE_SUCCESS"); break;

		//-- Events --//

	case FTCORE_RESULT::FTCORE_EVT_CLIENT_DETECTDISCON:
		::sprintf_s(buffer, MAX_PATH, "FTCORE_SUCCESS"); break;

	case FTCORE_RESULT::FTCORE_EVT_CLIENT_RECEIVED:
		::sprintf_s(buffer, MAX_PATH, "FTCORE_EVT_CLIENT_RECEIVED"); break;

		//-- Errors --//

	case FTCORE_RESULT::FTCORE_ERR_CLIENT_NOTSERVER:
		::sprintf_s(buffer, MAX_PATH, "FTCORE_ERR_CLIENT_NOTSERVER"); break;

	case FTCORE_RESULT::FTCORE_ERR_CLIENT_FAILSERVER:
		::sprintf_s(buffer, MAX_PATH, "FTCORE_ERR_CLIENT_FAILSERVER"); break;

	case FTCORE_RESULT::FTCORE_ERR_CLIENT_NOEXIST:
		::sprintf_s(buffer, MAX_PATH, "FTCORE_ERR_CLIENT_NOEXIST"); break;

	case FTCORE_RESULT::FTCORE_ERR_CLIENT_ALREADY:
		::sprintf_s(buffer, MAX_PATH, "FTCORE_ERR_CLIENT_ALREADY"); break;

	case FTCORE_RESULT::FTCORE_ERR_CLIENT_PARAMETER:
		::sprintf_s(buffer, MAX_PATH, "FTCORE_ERR_CLIENT_PARAMETER"); break;

	case FTCORE_RESULT::FTCORE_ERR_CLIENT_HOSTINFO:
		::sprintf_s(buffer, MAX_PATH, "FTCORE_ERR_CLIENT_HOSTINFO"); break;

	case FTCORE_RESULT::FTCORE_ERR_CLIENT_SOCKET:
		::sprintf_s(buffer, MAX_PATH, "FTCORE_ERR_CLIENT_SOCKET"); break;

	case FTCORE_RESULT::FTCORE_ERR_CLIENT_REFUSED:
		::sprintf_s(buffer, MAX_PATH, "FTCORE_ERR_CLIENT_REFUSED"); break;

	case FTCORE_RESULT::FTCORE_ERR_CLIENT_UNREACHED:
		::sprintf_s(buffer, MAX_PATH, "FTCORE_ERR_CLIENT_UNREACHED"); break;

	case FTCORE_RESULT::FTCORE_ERR_CLIENT_CONNECT:
		::sprintf_s(buffer, MAX_PATH, "FTCORE_ERR_CLIENT_CONNECT"); break;

	case FTCORE_RESULT::FTCORE_ERR_CLIENT_ESTABLISH:
		::sprintf_s(buffer, MAX_PATH, "FTCORE_ERR_CLIENT_ESTABLISH"); break;

	case FTCORE_RESULT::FTCORE_ERR_CLIENT_MESSAGESEND:
		::sprintf_s(buffer, MAX_PATH, "FTCORE_ERR_CLIENT_MESSAGESEND"); break;

	case FTCORE_RESULT::FTCORE_ERR_CLIENT_MESSAGERECV:
		::sprintf_s(buffer, MAX_PATH, "FTCORE_ERR_CLIENT_MESSAGERECV"); break;

	case FTCORE_RESULT::FTCORE_ERR_CLIENT_CONNUNKNOWN:
		::sprintf_s(buffer, MAX_PATH, "FTCORE_ERR_CLIENT_CONNUNKNOWN"); break;

	default:
		::sprintf_s(buffer, MAX_PATH, "FTCORE_UNKNOWN_STATE");
		break;
	}

	return buffer;
}

//----------------------------------------------------------------------------------
//
// Convert Enum of Category to String.
//
// result		[IN]	: Enum of Category
// buffer		[OUT]	: For return buffer
//
// return				: Pointer of buffer.
//----------------------------------------------------------------------------------
char* ConvertString(DefaultCategory category, char* buffer)
{
	switch (category)
	{
	case DefaultCategory::NON:
		::sprintf_s(buffer, MAX_PATH, "NON"); break;

	case DefaultCategory::APP:
		::sprintf_s(buffer, MAX_PATH, "APP"); break;

	case DefaultCategory::SYSTEM:
		::sprintf_s(buffer, MAX_PATH, "SYSTEM"); break;

	case DefaultCategory::USER:
		::sprintf_s(buffer, MAX_PATH, "USER"); break;

	case DefaultCategory::UI:
		::sprintf_s(buffer, MAX_PATH, "UI"); break;

	case DefaultCategory::WF:
		::sprintf_s(buffer, MAX_PATH, "WF"); break;

	case DefaultCategory::DEVICE:
		::sprintf_s(buffer, MAX_PATH, "DEVICE"); break;

	case DefaultCategory::DEBUG:
		::sprintf_s(buffer, MAX_PATH, "DEBUG"); break;

	case DefaultCategory::STEP:
		::sprintf_s(buffer, MAX_PATH, "STEP"); break;

	case DefaultCategory::EVENT:
		::sprintf_s(buffer, MAX_PATH, "EVENT"); break;

	case DefaultCategory::COMM:
		::sprintf_s(buffer, MAX_PATH, "COMM"); break;
	}

	return buffer;
}

//----------------------------------------------------------------------------------
//
// Convert Enum of Severity to String.
//
// result		[IN]	: Enum of Severity
// buffer		[OUT]	: For return buffer
//
// return				: Pointer of buffer.
//----------------------------------------------------------------------------------
char* ConvertString(Severity severity, char* buffer)
{
	switch (severity)
	{
	case Severity::NONE:
		::sprintf_s(buffer, MAX_PATH, "NON"); break;

	case Severity::INFO:
		::sprintf_s(buffer, MAX_PATH, "INFO"); break;

	case Severity::NOTICE:
		::sprintf_s(buffer, MAX_PATH, "NOTICE"); break;

	case Severity::WARNING:
		::sprintf_s(buffer, MAX_PATH, "WARNING"); break;

	case Severity::ERR:
		::sprintf_s(buffer, MAX_PATH, "ERR"); break;

	case Severity::FATAL:
		::sprintf_s(buffer, MAX_PATH, "FATAL"); break;
	}

	return buffer;
}

//----------------------------------------------------------------------------------
//
// Convert Enum of CallAPIs to String.
//
// result		[IN]	: Enum of CallAPIs
// buffer		[OUT]	: For return buffer
//
// return				: Pointer of buffer.
//----------------------------------------------------------------------------------
char* ConvertString(CallAPIs api, char* buffer)
{
	switch (api)
	{
	case CallAPIs::_FTCORE_StartTriggerWithParam_:
		::sprintf_s(buffer, MAX_PATH, "FTCORE_StartTriggerWithParam"); break;

	case CallAPIs::_FTCORE_StartTriggerWithSetup_:
		::sprintf_s(buffer, MAX_PATH, "FTCORE_StartTriggerWithSetup"); break;
	}

	return buffer;
}

//----------------------------------------------------------------------------------
//
// Convert Enum of TopmostState to String.
//
// result		[IN]	: Enum of TopmostState
// buffer		[OUT]	: For return buffer
//
// return				: Pointer of buffer.
//----------------------------------------------------------------------------------
char* ConvertString(TopmostStates state, char* buffer)
{
	switch (state)
	{
	case TopmostStates::STATE_FALSE:
		::sprintf_s(buffer, MAX_PATH, "STATE_FALSE"); break;

	case TopmostStates::STATE_TRUE:
		::sprintf_s(buffer, MAX_PATH, "STATE_TRUE"); break;
	}

	return buffer;
}

//----------------------------------------------------------------------------------
//
// Convert Enum of WindowStates to String.
//
// result		[IN]	: Enum of WindowStates
// buffer		[OUT]	: For return buffer
//
// return				: Pointer of buffer.
//----------------------------------------------------------------------------------
char* ConvertString(WindowStates state, char* buffer)
{
	switch (state)
	{
		case WindowStates::SHOW_WINDOW_NORMALY:
			::sprintf_s(buffer, MAX_PATH, "SHOW_WINDOW_NORMALY"); break;

		case WindowStates::SHOW_WINDOW_MAXIMIZE:
			::sprintf_s(buffer, MAX_PATH, "SHOW_WINDOW_MAXIMIZE"); break;

		case WindowStates::MINIMIZE_IN_TASKBAR:
			::sprintf_s(buffer, MAX_PATH, "MINIMIZE_IN_TASKBAR"); break;

		case WindowStates::HIDE_IN_SYSTEMTRAY:
			::sprintf_s(buffer, MAX_PATH, "HIDE_IN_SYSTEMTRAY"); break;

		case WindowStates::WINDOW_HIDDEN:
			::sprintf_s(buffer, MAX_PATH, "WINDOW_HIDDEN"); break;
	}

	return buffer;
}

//----------------------------------------------------------------------------------
//
// Get stack frame information.
// It can be obtained correctly when in debug mode, but not in release mode.
//
// depth		[IN]	: stack frame depth
// buffer		[OUT]	: For return buffer
//
// return				: Pointer of buffer.
//----------------------------------------------------------------------------------
char* GetStackFrame(long depth, char* buffer)
{
	CONTEXT context;
	::RtlCaptureContext(&context);

	// include self (+1) and parent (+1) = (+2)
	int stacknum = depth + 2;

	STACKFRAME sf; ::ZeroMemory(&sf, sizeof(sf));
	sf.AddrPC.Offset = context.Rip;
	sf.AddrStack.Offset = context.Rsp;
	sf.AddrFrame.Offset = context.Rsp;
	sf.AddrPC.Mode = AddrModeFlat;
	sf.AddrStack.Mode = AddrModeFlat;
	sf.AddrFrame.Mode = AddrModeFlat;

	HANDLE pch = GetCurrentProcess();
	HANDLE pth = GetCurrentThread();

	BOOL bresult = TRUE;
	int count = 0;

	//load symbols
	::SymInitialize(pch, NULL, TRUE);

	while (bresult && count < stacknum)
	{
		bresult = ::StackWalk64(IMAGE_FILE_MACHINE_AMD64, pch, pth, &sf, (void*)&context, NULL, SymFunctionTableAccess, SymGetModuleBase, NULL);

		if (bresult)
		{
			const int MaxNameLen = 256;
			char symbuff[sizeof(SYMBOL_INFO) + MAX_SYM_NAME * sizeof(TCHAR)];
			char name[MaxNameLen];
			char module[MaxNameLen];
			PSYMBOL_INFO psymbol = (PSYMBOL_INFO)symbuff;
			psymbol->SizeOfStruct = sizeof(SYMBOL_INFO);
			psymbol->MaxNameLen = MAX_SYM_NAME;
			DWORD64 displacement;
			::SymFromAddr(pch, (ULONG64)sf.AddrPC.Offset, &displacement, psymbol);

			//char linebuff[sizeof(IMAGEHLP_LINE64)];
			//DWORD disp;
			//PIMAGEHLP_LINE64 pimgline = (PIMAGEHLP_LINE64)linebuff;
			//pimgline->SizeOfStruct = sizeof(IMAGEHLP_LINE64);
			//bresult = ::SymGetLineFromAddr64(pch, sf.AddrPC.Offset, &disp, pimgline);

			::sprintf_s(buffer, MAX_PATH, "%s()", psymbol->Name);
		}

		count++;
	}

	return buffer;
}
#pragma endregion Utilities