﻿#include <iostream>
#include <conio.h>
#include <windows.h>
#include <dbghelp.h>
#include <psapi.h>
#pragma comment(lib, "version.lib")
#pragma comment(lib, "dbghelp.lib")
#pragma comment(lib, "psapi.lib" )

// For using FTSDK
#include "..\FTSDK\h\ftsdk_core.h"

#ifdef _DEBUG
#pragma comment(lib, "..\\ftsdk\\lib\\ft_cli_d.lib")
#pragma comment(lib, "..\\ftsdk\\lib\\ft_rmt_d.lib")
#else
#pragma comment(lib, "..\\ftsdk\\lib\\ft_cli.lib")
#pragma comment(lib, "..\\ftsdk\\lib\\ft_rmt.lib")
#endif


//----------------------------------------------------------------------------------
//
// Default category list.
//
//----------------------------------------------------------------------------------
enum DefaultCategory
{
	NON,				// No categorized
	APP,				// Application
	SYSTEM,				// System
	USER,				// User operation
	UI,					// GUI operation
	WF,					// Work flow
	DEVICE,				// Device
	DEBUG,				// Debug
	STEP,				// Step
	EVENT,				// Event
	COMM,				// Communication port

	NUMBER_OF_CATEGORY	// Number of category
};

//----------------------------------------------------------------------------------
//
// Logging severity list.
//
//----------------------------------------------------------------------------------
enum Severity
{
	NONE,				// No setting
	INFO,				// Information
	NOTICE,				// Notice
	WARNING,			// Warning
	ERR,				// Normal error
	FATAL,				// Fatal error
	
	NUMBER_OF_SEVERITY	// Number of severity
};


//----------------------------------------------------------------------------------
//
// Macro
//
//----------------------------------------------------------------------------------
#define WRITEOPEN(str) std::cout << (str)
#define WRITELINE(str) std::cout << (str) << std::endl
#define WRITEFMTL(str1, str2) std::cout << (str1) << (str2) << std::endl
#define KEY_ESCAPE '\x1b'
#define FTSDK_DLL "ft_cli.dll"


//----------------------------------------------------------------------------------
//
// Prototype
//
//----------------------------------------------------------------------------------
void GetFileVersion(char* version);
void GetCopyright(char* copyright);
char* ConvertString(FTCORE_RESULT result, char* buffer);
char* ConvertString(DefaultCategory category, char* buffer);
char* ConvertString(Severity category, char* buffer);
void OutputLog(char* message);
char* GetStackFrame(long depth, char* buffer);


//----------------------------------------------------------------------------------
//
// LoggingFoot sample program.
// How to use FTCORE_StartProcess and FTCORE_SetDefaultCategory.
//
//----------------------------------------------------------------------------------
int main()
{
	//_CrtSetDbgFlag(_CRTDBG_ALLOC_MEM_DF | _CRTDBG_LEAK_CHECK_DF);

	char copyright[MAX_PATH] = {}; GetCopyright(copyright);
	char version[MAX_PATH] = {}; GetFileVersion(version);

	WRITELINE("**********************************************************************");
	WRITELINE("");
	WRITELINE("  LoggingFoot FTSDK sample program.");
	WRITELINE("  How to use FTCORE_StartProcess and FTCORE_LoadDefaultCategory.");
	WRITELINE("");
	WRITEFMTL("  ", copyright);
	WRITELINE("");
	WRITEFMTL("                                                  FTSDK ver.", version);
	WRITELINE("**********************************************************************");
	WRITELINE("");
	WRITELINE("First, Please start Logging server.");
	WRITELINE("And next, press any key. (Press Esc key to exit this program.)");
	WRITELINE("Logging client will start.");
	WRITELINE("");

	// Destination server information.
	char server[] = "localhost";
	int port = 50500;

	// API execution result.
	FTCORE_RESULT result = FTCORE_RESULT::FTCORE_UNKNOWN_STATE;

	// Buffer for string convert.
	char buffer[MAX_PATH] = {};

	// Wait for key input.
	WRITELINE("> Wait for any key to be pressed ...");
	WRITEOPEN("> ");
	char key = (char)::_getch();
	::putchar(key);
	WRITELINE("");
	WRITEOPEN("> ");
	if (key == KEY_ESCAPE) WRITELINE("Esc key was pressed.");
	else WRITEFMTL(key, " key was pressed.");
	switch (key)
	{
		//- Exit program -//
		case KEY_ESCAPE:
			break;

		//- Startup Logging Client -//
		default:

			// Logging Client process start.
			WRITELINE("> Called FTCORE_StartProcess()..");
			result = FTCORE_StartProcess(server, port);

			WRITEFMTL("> result: ", ConvertString(result, buffer));
			WRITELINE("");
			break;
	}

	if (result == FTCORE_RESULT::FTCORE_SUCCESS)
	{
		//- Directs loading of default category that stored in Logging Serever. -//

		// Directs loading of default category.
		WRITELINE("> Called FTCORE_LoadDefaultCategory()..");
		result = FTCORE_LoadDefaultCategory();

		WRITEFMTL("> result: ", ConvertString(result, buffer));
		WRITELINE("");
	}

	if (result == FTCORE_RESULT::FTCORE_SUCCESS)
	{
		//- Log out input keys -//

		// Log message buffer
		char message[MAX_MESSAGE_SIZE] = {};

		WRITELINE("> Press any key then, Output log message.");
		WRITELINE("");
		
		while (key != KEY_ESCAPE)
		{
			WRITEOPEN("> ");
			key = (char)::_getch();
			::putchar(key);
			WRITEOPEN(" key was pressed.");
			WRITELINE("");
			if(key == KEY_ESCAPE)
				::sprintf_s(message, MAX_MESSAGE_SIZE, "Esc key was pressed.");
			else
				::sprintf_s(message, MAX_MESSAGE_SIZE, "%c key was pressed.", key);
			OutputLog(message);
		}
		
		//- Exit program -//

		if (key == KEY_ESCAPE)
		{
			// Logging Client Exit process
			WRITELINE("> Called FTCORE_ExitProcess()..");
			result = FTCORE_ExitProcess();

			WRITEFMTL("> result: ", ConvertString(result, buffer));
			WRITELINE("");
		}
	}

	// Press any key to exit program.
	WRITELINE("Press any key again to exit program.");
	::_getch();
}

//----------------------------------------------------------------------------------
//
// Log output.
//
// message		[IN]	: Content of message.
//
//----------------------------------------------------------------------------------
void OutputLog(char* message)
{
	// Get log categories at random
	int index = 0;

	// Get caller method.
	char path[MAX_PATH] = {};
	GetStackFrame(1, path);

	// Get log categories at random
	int categorylen = DefaultCategory::NUMBER_OF_CATEGORY;
	index = ::rand() % categorylen;
	char category[MAX_PATH] = {}; ConvertString((DefaultCategory)index, category);

	// Get log severity at random
	int severitylen = Severity::NUMBER_OF_SEVERITY;
	index = ::rand() % severitylen;
	char severity[MAX_PATH] = {}; ConvertString((Severity)index, severity);

	// API execution
	WRITELINE("> Called FTCORE_SendMessage(...)");
	FTCORE_RESULT result = FTCORE_SendMessage(path, category, severity, message);

	// Buffer for string convert.
	char buffer[MAX_PATH] = {};
	WRITEFMTL("> result: ", ConvertString(result, buffer));
	WRITELINE("");
}

//----------------------------------------------------------------------------------
//
// Get product version information.
//
//----------------------------------------------------------------------------------
void GetFileVersion(char* version)
{
	char filename[MAX_PATH] = FTSDK_DLL;
	//::GetModuleFileNameA(NULL, filename, sizeof(filename));
	int size = ::GetFileVersionInfoSizeA(filename, NULL);
	BYTE* pver = new BYTE[size];
	if (::GetFileVersionInfoA(filename, NULL, size, pver))
	{
		VS_FIXEDFILEINFO* pfi;
		unsigned int len;
		::VerQueryValueA(pver, "\\", (void**)&pfi, &len);

		::sprintf_s(version, MAX_PATH, "%d.%d.%d.%d",
			HIWORD(pfi->dwFileVersionMS),
			LOWORD(pfi->dwFileVersionMS),
			HIWORD(pfi->dwFileVersionLS),
			LOWORD(pfi->dwFileVersionLS));
	}
}

//----------------------------------------------------------------------------------
//
// Get copyright information.
//
//----------------------------------------------------------------------------------
void GetCopyright(char* copyright)
{
	char filename[MAX_PATH] = {};
	::GetModuleFileNameA(NULL, filename, sizeof(filename));
	int size = ::GetFileVersionInfoSizeA(filename, NULL);
	BYTE* pver = new BYTE[size];
	if (::GetFileVersionInfoA(filename, NULL, size, pver))
	{
		WORD* pci;
		unsigned int len;
		::VerQueryValueA(pver, "\\VarFileInfo\\Translation", (void**)&pci, &len);

		char block[MAX_PATH] = {};
		char* info;
		::sprintf_s(block, MAX_PATH, "\\StringFileInfo\\%04X%04X\\LegalCopyright", pci[0], pci[1]);
		::VerQueryValueA(pver, block, (void**)&info, &len);
		if (len > 0) ::sprintf_s(copyright, MAX_PATH, "%s", info);
	}

	delete[] pver;
}

//----------------------------------------------------------------------------------
//
// Convert FTCORE_RESULT to String.
//
// result		[IN]	: Result of Called FTCORE API.
// buffer		[OUT]	: For return buffer
//
// return				: Pointer of buffer.
//----------------------------------------------------------------------------------
char* ConvertString(FTCORE_RESULT result, char* buffer)
{
	switch (result)
	{
		//-- Sucess --//

	case FTCORE_RESULT::FTCORE_SUCCESS:
		::sprintf_s(buffer, MAX_PATH, "FTCORE_SUCCESS"); break;

		//-- Events --//

	case FTCORE_RESULT::FTCORE_EVT_CLIENT_DETECTDISCON:
		::sprintf_s(buffer, MAX_PATH, "FTCORE_SUCCESS"); break;

	case FTCORE_RESULT::FTCORE_EVT_CLIENT_RECEIVED:
		::sprintf_s(buffer, MAX_PATH, "FTCORE_EVT_CLIENT_RECEIVED"); break;

		//-- Errors --//

	case FTCORE_RESULT::FTCORE_ERR_CLIENT_NOTSERVER:
		::sprintf_s(buffer, MAX_PATH, "FTCORE_ERR_CLIENT_NOTSERVER"); break;

	case FTCORE_RESULT::FTCORE_ERR_CLIENT_FAILSERVER:
		::sprintf_s(buffer, MAX_PATH, "FTCORE_ERR_CLIENT_FAILSERVER"); break;

	case FTCORE_RESULT::FTCORE_ERR_CLIENT_NOEXIST:
		::sprintf_s(buffer, MAX_PATH, "FTCORE_ERR_CLIENT_NOEXIST"); break;

	case FTCORE_RESULT::FTCORE_ERR_CLIENT_ALREADY:
		::sprintf_s(buffer, MAX_PATH, "FTCORE_ERR_CLIENT_ALREADY"); break;

	case FTCORE_RESULT::FTCORE_ERR_CLIENT_PARAMETER:
		::sprintf_s(buffer, MAX_PATH, "FTCORE_ERR_CLIENT_PARAMETER"); break;

	case FTCORE_RESULT::FTCORE_ERR_CLIENT_HOSTINFO:
		::sprintf_s(buffer, MAX_PATH, "FTCORE_ERR_CLIENT_HOSTINFO"); break;

	case FTCORE_RESULT::FTCORE_ERR_CLIENT_SOCKET:
		::sprintf_s(buffer, MAX_PATH, "FTCORE_ERR_CLIENT_SOCKET"); break;

	case FTCORE_RESULT::FTCORE_ERR_CLIENT_REFUSED:
		::sprintf_s(buffer, MAX_PATH, "FTCORE_ERR_CLIENT_REFUSED"); break;

	case FTCORE_RESULT::FTCORE_ERR_CLIENT_UNREACHED:
		::sprintf_s(buffer, MAX_PATH, "FTCORE_ERR_CLIENT_UNREACHED"); break;

	case FTCORE_RESULT::FTCORE_ERR_CLIENT_CONNECT:
		::sprintf_s(buffer, MAX_PATH, "FTCORE_ERR_CLIENT_CONNECT"); break;

	case FTCORE_RESULT::FTCORE_ERR_CLIENT_ESTABLISH:
		::sprintf_s(buffer, MAX_PATH, "FTCORE_ERR_CLIENT_ESTABLISH"); break;

	case FTCORE_RESULT::FTCORE_ERR_CLIENT_MESSAGESEND:
		::sprintf_s(buffer, MAX_PATH, "FTCORE_ERR_CLIENT_MESSAGESEND"); break;

	case FTCORE_RESULT::FTCORE_ERR_CLIENT_MESSAGERECV:
		::sprintf_s(buffer, MAX_PATH, "FTCORE_ERR_CLIENT_MESSAGERECV"); break;

	case FTCORE_RESULT::FTCORE_ERR_CLIENT_CONNUNKNOWN:
		::sprintf_s(buffer, MAX_PATH, "FTCORE_ERR_CLIENT_CONNUNKNOWN"); break;

	default:
		::sprintf_s(buffer, MAX_PATH, "FTCORE_UNKNOWN_STATE");
		break;
	}

	return buffer;
}

//----------------------------------------------------------------------------------
//
// Convert Enum of Category to String.
//
// result		[IN]	: Enum of Category
// buffer		[OUT]	: For return buffer
//
// return				: Pointer of buffer.
//----------------------------------------------------------------------------------
char* ConvertString(DefaultCategory category, char* buffer)
{
	switch (category)
	{
		case DefaultCategory::NON:
			::sprintf_s(buffer, MAX_PATH, "NON"); break;

		case DefaultCategory::APP:
			::sprintf_s(buffer, MAX_PATH, "APP"); break;

		case DefaultCategory::SYSTEM:
			::sprintf_s(buffer, MAX_PATH, "SYSTEM"); break;

		case DefaultCategory::USER:
			::sprintf_s(buffer, MAX_PATH, "USER"); break;

		case DefaultCategory::UI:
			::sprintf_s(buffer, MAX_PATH, "UI"); break;

		case DefaultCategory::WF:
			::sprintf_s(buffer, MAX_PATH, "WF"); break;

		case DefaultCategory::DEVICE:
			::sprintf_s(buffer, MAX_PATH, "DEVICE"); break;

		case DefaultCategory::DEBUG:
			::sprintf_s(buffer, MAX_PATH, "DEBUG"); break;

		case DefaultCategory::STEP:
			::sprintf_s(buffer, MAX_PATH, "STEP"); break;

		case DefaultCategory::EVENT:
			::sprintf_s(buffer, MAX_PATH, "EVENT"); break;

		case DefaultCategory::COMM:
			::sprintf_s(buffer, MAX_PATH, "COMM"); break;
	}

	return buffer;
}

//----------------------------------------------------------------------------------
//
// Convert Enum of Severity to String.
//
// result		[IN]	: Enum of Severity
// buffer		[OUT]	: For return buffer
//
// return				: Pointer of buffer.
//----------------------------------------------------------------------------------
char* ConvertString(Severity severity, char* buffer)
{
	switch (severity)
	{
		case Severity::NONE:
			::sprintf_s(buffer, MAX_PATH, "NON"); break;

		case Severity::INFO:
			::sprintf_s(buffer, MAX_PATH, "INFO"); break;

		case Severity::NOTICE:
			::sprintf_s(buffer, MAX_PATH, "NOTICE"); break;

		case Severity::WARNING:
			::sprintf_s(buffer, MAX_PATH, "WARNING"); break;

		case Severity::ERR:
			::sprintf_s(buffer, MAX_PATH, "ERR"); break;

		case Severity::FATAL:
			::sprintf_s(buffer, MAX_PATH, "FATAL"); break;
	}

	return buffer;
}

//----------------------------------------------------------------------------------
//
// Get stack frame information.
// It can be obtained correctly when in debug mode, but not in release mode.
//
// depth		[IN]	: stack frame depth
// buffer		[OUT]	: For return buffer
//
// return				: Pointer of buffer.
//----------------------------------------------------------------------------------
char* GetStackFrame(long depth, char* buffer)
{
	CONTEXT context;
	::RtlCaptureContext(&context);

	// include self (+1) and parent (+1) = (+2)
	int stacknum = depth + 2;

	STACKFRAME sf; ::ZeroMemory(&sf, sizeof(sf));
	sf.AddrPC.Offset = context.Rip;
	sf.AddrStack.Offset = context.Rsp;
	sf.AddrFrame.Offset = context.Rsp;
	sf.AddrPC.Mode = AddrModeFlat;
	sf.AddrStack.Mode = AddrModeFlat;
	sf.AddrFrame.Mode = AddrModeFlat;

	HANDLE pch = GetCurrentProcess();
	HANDLE pth = GetCurrentThread();

	BOOL bresult = TRUE;
	int count = 0;
	
	//load symbols
	::SymInitialize(pch, NULL, TRUE); 

	while (bresult && count < stacknum)
	{
		bresult = ::StackWalk64(IMAGE_FILE_MACHINE_AMD64, pch, pth, &sf, (void*)&context, NULL, SymFunctionTableAccess, SymGetModuleBase, NULL);

		if (bresult)
		{
			const int MaxNameLen = 256;
			char symbuff[sizeof(SYMBOL_INFO) + MAX_SYM_NAME * sizeof(TCHAR)];
			char name[MaxNameLen];
			char module[MaxNameLen];
			PSYMBOL_INFO psymbol = (PSYMBOL_INFO)symbuff;
			psymbol->SizeOfStruct = sizeof(SYMBOL_INFO);
			psymbol->MaxNameLen = MAX_SYM_NAME;
			DWORD64 displacement;
			::SymFromAddr(pch, (ULONG64)sf.AddrPC.Offset, &displacement, psymbol);

			//char linebuff[sizeof(IMAGEHLP_LINE64)];
			//DWORD disp;
			//PIMAGEHLP_LINE64 pimgline = (PIMAGEHLP_LINE64)linebuff;
			//pimgline->SizeOfStruct = sizeof(IMAGEHLP_LINE64);
			//bresult = ::SymGetLineFromAddr64(pch, sf.AddrPC.Offset, &disp, pimgline);

			::sprintf_s(buffer, MAX_PATH, "%s()", psymbol->Name);
		}

		count++;
	}

	return buffer;
}

