﻿''' <summary>
''' VB.NET wrapper for the LoggingFoot FTSDK.
''' <para> ver.1.0.0.0	new created.</para>
''' <para>Copyright © 2025 Quantyworks Software</para>
''' </summary>
Public Class FtsdkVBWrapper

#Region "Consts"
    ''' <summary>
    ''' LoggingFoot client module name.
    ''' </summary>
    Private Const _DLL_NAME As System.String = "ft_cli.dll"
#End Region 'Consts

#Region "Enums"
    ''' <summary>
    ''' Represents the execution result of the LoggingFoot client.
    ''' </summary>
    Public Enum FTCORE_RESULT

        FTCORE_UNKNOWN_STATE = -1           ' The state is undefined.

        FTCORE_SUCCESS = 0                  ' Operation completed successfully.


        '//-- Events --//'

        FTCORE_EVT_CLIENT_DETECTDISCON = 4  ' Client detected a disconnection from the server.
        FTCORE_EVT_CLIENT_RECEIVED          ' Client received data from the server.


        '//-- Errors --//'

        FTCORE_ERR_CLIENT_NOTSERVER = 21   ' The server is not running or does not exist.
        FTCORE_ERR_CLIENT_FAILSERVER       ' Failed to start the logging server.

        FTCORE_ERR_CLIENT_NOEXIST          ' alled before the process was created.
        FTCORE_ERR_CLIENT_ALREADY          ' The process has already been started.
        FTCORE_ERR_CLIENT_PARAMETER        ' Invalid parameters were provided.
        FTCORE_ERR_CLIENT_HOSTINFO         ' Failed to retrieve host information.
        FTCORE_ERR_CLIENT_SOCKET           ' Failed to create a socket.
        FTCORE_ERR_CLIENT_REFUSED          ' The target process is not accepting connections or refused the connection.
        FTCORE_ERR_CLIENT_UNREACHED        ' The network path to the destination is unknown.
        FTCORE_ERR_CLIENT_CONNECT          ' Connection failed due to an unknown cause.
        FTCORE_ERR_CLIENT_ESTABLISH        ' An error occurred during the connection establishment process.
        FTCORE_ERR_CLIENT_MESSAGESEND      ' Failed to send the message.
        FTCORE_ERR_CLIENT_MESSAGERECV      ' Failed to receive the message.
        FTCORE_ERR_CLIENT_CONNUNKNOWN      ' Received a connection notification from an unknown server.
    End Enum
#End Region 'Enums

#Region "FTCORE External API Definitions"
    ''' <summary>
    ''' External API definitions for FTCORE.
    ''' </summary>
    Private Class FTCORE_APIs
        ''' <summary>
        ''' Starts the LoggingFoot client process.
        ''' </summary>
        ''' <param name="servername">The server name Or IP address of the destination to connect to.</param>
        ''' <param name="portnumber">The port number of the destination server (49152–65535).</param>
        ''' <returns>
        ''' <para>SUCCESS   : FTCORE_SUCCESS</para>
        ''' <para>FAIL      : FTCORE_ERR_CLIENT_ALREADY</para>
        ''' <para>          : FTCORE_ERR_CLIENT_SOCKET</para>
        ''' <para>          : FTCORE_ERR_CLIENT_REFUSED</para>
        ''' <para>          : FTCORE_ERR_CLIENT_UNREACHED</para>
        ''' <para>          : FTCORE_ERR_CLIENT_CONNECT</para>
        ''' <para>          : FTCORE_ERR_CLIENT_ESTABLISH</para>
        ''' </returns>
        <System.Runtime.InteropServices.DllImport(_DLL_NAME, CallingConvention:=System.Runtime.InteropServices.CallingConvention.StdCall)>
        Friend Shared Function FTCORE_StartProcess(servername As String, portnumber As UShort) As FTCORE_RESULT
        End Function

        ''' <summary>
        ''' Starts the client process after the server process has been launched, using the specified parameters.
        ''' </summary>
        ''' <param name="serverpath">The full path to the destination server executable.</param>
        ''' <param name="servername">The server name Or IP address to connect to.</param>
        ''' <param name="portnumber">The port number of the destination server (49152–65535).</param>
        ''' <param name="viewstate">The window state of the server process.
        ''' <para>0: Default</para>
        ''' <para>1: Maximized</para>
        ''' <para>2: Minimized to the taskbar</para>
        ''' <para>3: Hidden in the system tray</para>
        ''' <para>4: Fully hidden</para>
        ''' </param>
        ''' <param name="topmost">
        ''' Specifies whether the window should stay on top of other windows.
        ''' <para>0: Disabled</para>
        ''' <para>1: Enabled</para>
        ''' </param>
        ''' <returns>
        ''' <para>SUCCESS   : FTCORE_SUCCESS</para>
        ''' <para>FAIL      : FTCORE_ERR_CLIENT_NOTSERVER</para>
        ''' <para>          : FTCORE_ERR_CLIENT_FAILSERVER</para>
        ''' <para>          : FTCORE_ERR_CLIENT_ALREADY</para>
        ''' <para>          : FTCORE_ERR_CLIENT_SOCKET</para>
        ''' <para>          : FTCORE_ERR_CLIENT_REFUSED</para>
        ''' <para>          : FTCORE_ERR_CLIENT_UNREACHED</para>
        ''' <para>          : FTCORE_ERR_CLIENT_CONNECT</para>
        ''' <para>          : FTCORE_ERR_CLIENT_ESTABLISH</para>
        ''' </returns>
        <System.Runtime.InteropServices.DllImport(_DLL_NAME, CallingConvention:=System.Runtime.InteropServices.CallingConvention.StdCall)>
        Friend Shared Function FTCORE_StartTriggerWithParam(serverpath As String, servername As String, portnumber As UShort, viewstate As Integer, topmost As Integer) As FTCORE_RESULT
        End Function

        ''' <summary>
        ''' Starts the client process after the server process has been launched, using the setup parameters.
        ''' </summary>
        ''' <param name="serverpath">The full path to the destination server executable.</param>
        ''' <param name="servername">The server name or IP address to connect to.</param>
        ''' <param name="portnumber">The port number of the destination server (49152–65535).</param>
        ''' <returns>
        ''' <para>SUCCESS   : FTCORE_SUCCESS</para>
        ''' <para>FAIL      : FTCORE_ERR_CLIENT_NOTSERVER</para>
        ''' <para>          : FTCORE_ERR_CLIENT_FAILSERVER</para>
        ''' <para>          : FTCORE_ERR_CLIENT_ALREADY</para>
        ''' <para>          : FTCORE_ERR_CLIENT_SOCKET</para>
        ''' <para>          : FTCORE_ERR_CLIENT_REFUSED</para>
        ''' <para>          : FTCORE_ERR_CLIENT_UNREACHED</para>
        ''' <para>          : FTCORE_ERR_CLIENT_CONNECT</para>
        ''' <para>          : FTCORE_ERR_CLIENT_ESTABLISH</para>
        ''' </returns>
        <System.Runtime.InteropServices.DllImport(_DLL_NAME, CallingConvention:=System.Runtime.InteropServices.CallingConvention.StdCall)>
        Friend Shared Function FTCORE_StartTriggerWithSetup(serverpath As String, servername As String, portnumber As UShort) As FTCORE_RESULT
        End Function

        ''' <summary>
        ''' Terminates the client process.
        ''' This function must be called to terminate the process if it was started using FTCORE_StartProcess().
        ''' </summary>
        ''' <returns>
        ''' <para>SUCCESS   : FTCORE_SUCCESS</para>
        ''' <para>FAIL      : -----</para>
        ''' </returns>
        <System.Runtime.InteropServices.DllImport(_DLL_NAME, CallingConvention:=System.Runtime.InteropServices.CallingConvention.StdCall)>
        Friend Shared Function FTCORE_ExitProcess() As FTCORE_RESULT
        End Function

        ''' <summary>
        ''' Terminates the client process after the server process has exited.
        ''' This function must be called to terminate the process if it was started using either FTCORE_StartTriggerWithParam() or FTCORE_StartTriggerWithSetup().
        ''' If no server process is running, only the client process will be terminated.
        ''' </summary>
        ''' <returns>
        ''' <para>SUCCESS   : FTCORE_SUCCESS</para>
        ''' <para>FAIL      : -----</para>
        ''' </returns>
        <System.Runtime.InteropServices.DllImport(_DLL_NAME, CallingConvention:=System.Runtime.InteropServices.CallingConvention.StdCall)>
        Friend Shared Function FTCORE_ExitTrigger() As FTCORE_RESULT
        End Function

        ''' <summary>
        ''' Sends a message to the server process.
        ''' </summary>
        ''' <param name="path">The caller's path or source identifier.</param>
        ''' <param name="category">The log category.</param>
        ''' <param name="severity">The log severity level.</param>
        ''' <param name="message">The message content to send.</param>
        ''' <returns>
        ''' <para>SUCCESS   : FTCORE_SUCCESS</para>
        ''' <para>FAIL      : FTCORE_ERR_CLIENT_NOEXIST</para>
        ''' <para>          : FTCORE_ERR_CLIENT_PARAMETER</para>
        ''' <para>          : FTCORE_ERR_CLIENT_MESSAGESEND</para>
        ''' </returns>
        <System.Runtime.InteropServices.DllImport(_DLL_NAME, CallingConvention:=System.Runtime.InteropServices.CallingConvention.StdCall)>
        Friend Shared Function FTCORE_SendMessage(path As String, category As String, severity As String, message As String) As FTCORE_RESULT
        End Function

        ''' <summary>
        ''' Instructs the server process to change its window display state.
        ''' </summary>
        ''' <param name="state">
        ''' The desired window state of the server process.
        ''' <para>0: Default</para>
        ''' <para>1: Maximized</para>
        ''' <para>2: Minimized to the taskbar</para>
        ''' <para>3: Hidden in the system tray</para>
        ''' <para>4: Fully hidden</para>
        ''' </param>
        ''' <returns>
        ''' <para>SUCCESS   : FTCORE_SUCCESS</para>
        ''' <para>FAIL      : FTCORE_ERR_CLIENT_NOEXIST</para>
        ''' <para>          : FTCORE_ERR_CLIENT_PARAMETER</para>
        ''' <para>          : FTCORE_ERR_CLIENT_MESSAGESEND</para>
        ''' </returns>
        <System.Runtime.InteropServices.DllImport(_DLL_NAME, CallingConvention:=System.Runtime.InteropServices.CallingConvention.StdCall)>
        Friend Shared Function FTCORE_SetWindowState(state As Integer) As FTCORE_RESULT
        End Function

        ''' <summary>
        ''' Instructs the server process to load the default logging category values.
        ''' </summary>
        ''' <returns>
        ''' <para>SUCCESS   : FTCORE_SUCCESS</para>
        ''' <para>FAIL      : FTCORE_ERR_CLIENT_NOEXIST</para>
        ''' <para>          : FTCORE_ERR_CLIENT_PARAMETER</para>
        ''' <para>          : FTCORE_ERR_CLIENT_MESSAGESEND</para>
        ''' </returns>
        <System.Runtime.InteropServices.DllImport(_DLL_NAME, CallingConvention:=System.Runtime.InteropServices.CallingConvention.StdCall)>
        Friend Shared Function FTCORE_LoadDefaultCategory() As FTCORE_RESULT
        End Function


        ''' <summary>
        ''' Instructs the server process to apply custom logging categories.
        ''' </summary>
        ''' <param name="categories">One or more category names, separated by commas if multiple.</param>
        ''' <returns>
        ''' <para>SUCCESS   : FTCORE_SUCCESS</para>
        ''' <para>FAIL      : FTCORE_ERR_CLIENT_NOEXIST</para>
        ''' <para>          : FTCORE_ERR_CLIENT_PARAMETER</para>
        ''' <para>          : FTCORE_ERR_CLIENT_MESSAGESEND</para>
        ''' </returns>
        <System.Runtime.InteropServices.DllImport(_DLL_NAME, CallingConvention:=System.Runtime.InteropServices.CallingConvention.StdCall)>
        Friend Shared Function FTCORE_SetCustomCategory(categories As String) As FTCORE_RESULT
        End Function

        ''' <summary>
        ''' Instructs the server process to apply the loaded category settings from the specified file.
        ''' </summary>
        ''' <param name="filename">The full path to the category settings file.</param>
        ''' <returns>
        ''' <para>SUCCESS   : FTCORE_SUCCESS</para>
        ''' <para>FAIL      : FTCORE_ERR_CLIENT_NOEXIST</para>
        ''' <para>          : FTCORE_ERR_CLIENT_PARAMETER</para>
        ''' <para>          : FTCORE_ERR_CLIENT_MESSAGESEND</para>
        ''' </returns>
        <System.Runtime.InteropServices.DllImport(_DLL_NAME, CallingConvention:=System.Runtime.InteropServices.CallingConvention.StdCall)>
        Friend Shared Function FTCORE_SetCustomCategoryFromFile(filename As String) As FTCORE_RESULT
        End Function
    End Class
#End Region 'FTCORE External API Definitions

#Region "LoggingClient Wrapper"
    ''' <summary>
    ''' Starts the LoggingFoot client process.
    ''' </summary>
    ''' <param name="servername">The server name or IP address of the destination to connect to.</param>
    ''' <param name="portnumber">The port number of the destination server (49152–65535).</param>
    ''' <returns>
    ''' <para>SUCCESS   : FTCORE_SUCCESS</para>
    ''' <para>FAIL      : FTCORE_ERR_CLIENT_ALREADY</para>
    ''' <para>          : FTCORE_ERR_CLIENT_SOCKET</para>
    ''' <para>          : FTCORE_ERR_CLIENT_REFUSED</para>
    ''' <para>          : FTCORE_ERR_CLIENT_UNREACHED</para>
    ''' <para>          : FTCORE_ERR_CLIENT_CONNECT</para>
    ''' <para>          : FTCORE_ERR_CLIENT_ESTABLISH</para>
    ''' </returns>
    Public Shared Function FTCORE_StartProcess(servername As String, portnumber As Integer) As FTCORE_RESULT

        Return FTCORE_APIs.FTCORE_StartProcess(servername, portnumber)
    End Function

    ''' <summary>
    ''' After the server process Is started with the parameters passed, the client process Is started.
    ''' </summary>
    ''' <param name="serverpath">The full path to the destination server executable.</param>
    ''' <param name="servername">The server name Or IP address to connect to.</param>
    ''' <param name="portnumber">The port number of the destination server (49152–65535).</param>
    ''' <param name="viewstate">The window state of the server process.
    ''' <para>0: Default</para>
    ''' <para>1: Maximized</para>
    ''' <para>2: Minimized to the taskbar</para>
    ''' <para>3: Hidden in the system tray</para>
    ''' <para>4: Fully hidden</para>
    ''' </param>
    ''' <param name="topmost">
    ''' Specifies whether the window should stay on top of other windows.
    ''' <para>0: Disabled</para>
    ''' <para>1: Enabled</para>
    ''' </param>
    ''' <returns>
    ''' <para>SUCCESS   : FTCORE_SUCCESS</para>
    ''' <para>FAIL      : FTCORE_ERR_CLIENT_NOTSERVER</para>
    ''' <para>          : FTCORE_ERR_CLIENT_FAILSERVER</para>
    ''' <para>          : FTCORE_ERR_CLIENT_ALREADY</para>
    ''' <para>          : FTCORE_ERR_CLIENT_SOCKET</para>
    ''' <para>          : FTCORE_ERR_CLIENT_REFUSED</para>
    ''' <para>          : FTCORE_ERR_CLIENT_UNREACHED</para>
    ''' <para>          : FTCORE_ERR_CLIENT_CONNECT</para>
    ''' <para>          : FTCORE_ERR_CLIENT_ESTABLISH</para>
    ''' </returns>
    Public Shared Function FTCORE_StartTriggerWithParam(serverpath As String, servername As String, portnumber As Integer, viewstate As Integer, topmost As Boolean) As FTCORE_RESULT

        Dim istop = If(topmost = True, 1, 0)
        Return FTCORE_APIs.FTCORE_StartTriggerWithParam(serverpath, servername, portnumber, viewstate, istop)
    End Function

    ''' <summary>
    ''' Starts the client process after the server process has been launched, using the setup parameters.
    ''' </summary>
    ''' <param name="serverpath">The full path to the destination server executable.</param>
    ''' <param name="servername">The server name or IP address to connect to.</param>
    ''' <param name="portnumber">The port number of the destination server (49152–65535).</param>
    ''' <returns>
    ''' <para>SUCCESS   : FTCORE_SUCCESS</para>
    ''' <para>FAIL      : FTCORE_ERR_CLIENT_NOTSERVER</para>
    ''' <para>          : FTCORE_ERR_CLIENT_FAILSERVER</para>
    ''' <para>          : FTCORE_ERR_CLIENT_ALREADY</para>
    ''' <para>          : FTCORE_ERR_CLIENT_SOCKET</para>
    ''' <para>          : FTCORE_ERR_CLIENT_REFUSED</para>
    ''' <para>          : FTCORE_ERR_CLIENT_UNREACHED</para>
    ''' <para>          : FTCORE_ERR_CLIENT_CONNECT</para>
    ''' <para>          : FTCORE_ERR_CLIENT_ESTABLISH</para>
    ''' </returns>
    Public Shared Function FTCORE_StartTriggerWithSetup(serverpath As String, servername As String, portnumber As Integer) As FTCORE_RESULT

        Return FTCORE_APIs.FTCORE_StartTriggerWithSetup(serverpath, servername, portnumber)
    End Function

    ''' <summary>
    ''' Terminates the client process.
    ''' This function must be called to terminate the process if it was started using FTCORE_StartProcess().
    ''' </summary>
    ''' <returns>
    ''' <para>SUCCESS   : FTCORE_SUCCESS</para>
    ''' <para>FAIL      : -----</para>
    ''' </returns>
    Public Shared Function FTCORE_ExitProcess() As FTCORE_RESULT

        Return FTCORE_APIs.FTCORE_ExitProcess()
    End Function

    ''' <summary>
    ''' Terminates the client process after the server process has exited.
    ''' This function must be called to terminate the process if it was started using either FTCORE_StartTriggerWithParam() or FTCORE_StartTriggerWithSetup().
    ''' If no server process is running, only the client process will be terminated.
    ''' </summary>
    ''' <returns>
    ''' <para>SUCCESS   : FTCORE_SUCCESS</para>
    ''' <para>FAIL      : -----</para>
    ''' </returns>
    Public Shared Function FTCORE_ExitTrigger() As FTCORE_RESULT

        Return FTCORE_APIs.FTCORE_ExitTrigger()
    End Function

    ''' <summary>
    ''' Sends a message to the server process.
    ''' </summary>
    ''' <param name="path">The caller's path or source identifier.</param>
    ''' <param name="category">The log category.</param>
    ''' <param name="severity">The log severity level.</param>
    ''' <param name="message">The message content to send.</param>
    ''' <returns>
    ''' <para>SUCCESS   : FTCORE_SUCCESS</para>
    ''' <para>FAIL      : FTCORE_ERR_CLIENT_NOEXIST</para>
    ''' <para>          : FTCORE_ERR_CLIENT_PARAMETER</para>
    ''' <para>          : FTCORE_ERR_CLIENT_MESSAGESEND</para>
    ''' </returns>
    Public Shared Function FTCORE_SendMessage(path As String, category As String, severity As String, message As String) As FTCORE_RESULT

        Return FTCORE_APIs.FTCORE_SendMessage(path, category, severity, message)
    End Function

    ''' <summary>
    ''' Instructs the server process to change its window display state.
    ''' </summary>
    ''' <param name="state">
    ''' The desired window state of the server process.
    ''' <para>0: Default</para>
    ''' <para>1: Maximized</para>
    ''' <para>2: Minimized to the taskbar</para>
    ''' <para>3: Hidden in the system tray</para>
    ''' <para>4: Fully hidden</para>
    ''' </param>
    ''' <returns>
    ''' <para>SUCCESS   : FTCORE_SUCCESS</para>
    ''' <para>FAIL      : FTCORE_ERR_CLIENT_NOEXIST</para>
    ''' <para>          : FTCORE_ERR_CLIENT_PARAMETER</para>
    ''' <para>          : FTCORE_ERR_CLIENT_MESSAGESEND</para>
    ''' </returns>
    Public Shared Function FTCORE_SetWindowState(state As Integer) As FTCORE_RESULT

        Return FTCORE_APIs.FTCORE_SetWindowState(state)
    End Function

    ''' <summary>
    ''' Instructs the server process to load the default logging category values.
    ''' </summary>
    ''' <returns>
    ''' <para>SUCCESS   : FTCORE_SUCCESS</para>
    ''' <para>FAIL      : FTCORE_ERR_CLIENT_NOEXIST</para>
    ''' <para>          : FTCORE_ERR_CLIENT_PARAMETER</para>
    ''' <para>          : FTCORE_ERR_CLIENT_MESSAGESEND</para>
    ''' </returns>
    Public Shared Function FTCORE_LoadDefaultCategory() As FTCORE_RESULT

        Return FTCORE_APIs.FTCORE_LoadDefaultCategory()
    End Function

    ''' <summary>
    ''' Instructs the server process to apply custom logging categories.
    ''' </summary>
    ''' <param name="categories">One Or more category names, separated by commas if multiple.</param>
    ''' <returns>
    ''' <para>SUCCESS   : FTCORE_SUCCESS</para>
    ''' <para>FAIL      : FTCORE_ERR_CLIENT_NOEXIST</para>
    ''' <para>          : FTCORE_ERR_CLIENT_PARAMETER</para>
    ''' <para>          : FTCORE_ERR_CLIENT_MESSAGESEND</para>
    ''' </returns>
    Public Shared Function FTCORE_SetCustomCategory(categories As String) As FTCORE_RESULT

        Return FTCORE_APIs.FTCORE_SetCustomCategory(categories)
    End Function

    ''' <summary>
    ''' Instructs the server process to apply the loaded category settings from the specified file.
    ''' </summary>
    ''' <param name="filename">Full path of category setting file name.</param>
    ''' <returns>
    ''' <para>SUCCESS   : FTCORE_SUCCESS</para>
    ''' <para>FAIL      : FTCORE_ERR_CLIENT_NOEXIST</para>
    ''' <para>          : FTCORE_ERR_CLIENT_PARAMETER</para>
    ''' <para>          : FTCORE_ERR_CLIENT_MESSAGESEND</para>
    ''' </returns>
    Public Shared Function FTCORE_SetCustomCategoryFromFile(filename As String) As FTCORE_RESULT

        Return FTCORE_APIs.FTCORE_SetCustomCategoryFromFile(filename)
    End Function
#End Region 'LoggingClient Wrapper

End Class
