﻿Module Program
    ''' <summary>
    ''' Default category list.
    ''' </summary>
    Enum DefaultCategory
        ''' <summary>
        ''' No categorized
        ''' </summary>
        NON
        ''' <summary>
        ''' Application
        ''' </summary>
        APP
        ''' <summary>
        ''' System
        ''' </summary>
        SYSTEM
        ''' <summary>
        ''' User operation
        ''' </summary>
        USER
        ''' <summary>
        ''' GUI operation
        ''' </summary>
        UI
        ''' <summary>
        ''' Work flow
        ''' </summary>
        WF
        ''' <summary>
        ''' Device
        ''' </summary>
        DEVICE
        ''' <summary>
        ''' Debug
        ''' </summary>
        DEBUG
        ''' <summary>
        ''' Step
        ''' </summary>
        STEPLOG
        ''' <summary>
        ''' Event
        ''' </summary>
        EVENTLOG
        ''' <summary>
        ''' Communication port
        ''' </summary>
        COMM
    End Enum

    ''' <summary>
    ''' Logging severity list.
    ''' </summary>
    Enum Severity
        ''' <summary>
        ''' No setting
        ''' </summary>
        NON
        ''' <summary>
        ''' Information
        ''' </summary>
        INFO
        ''' <summary>
        ''' Notice
        ''' </summary>
        NOTICE
        ''' <summary>
        ''' Warning
        ''' </summary>
        WARNING
        ''' <summary>
        ''' Normal error
        ''' </summary>
        ONERROR
        ''' <summary>
        ''' Fatal error
        ''' </summary>
        FATAL
    End Enum

    ''' <summary>
    ''' LoggingFoot sample program.
    ''' How to use FTCORE_StartProcess and FTCORE_SetDefaultCategory.
    ''' </summary>
    Sub Main()

        ' Get assembly information.
        Dim copyright = ProductCopyright
        Dim Version = FtsdkVersion

        Console.WriteLine("**********************************************************************")
        Console.WriteLine("")
        Console.WriteLine("  LoggingFoot FTSDK sample program.")
        Console.WriteLine("  How to use FTCORE_StartProcess and FTCORE_LoadDefaultCategory.")
        Console.WriteLine("")
        Console.WriteLine($"  {copyright}")
        Console.WriteLine("")
        Console.WriteLine($"                                                  FTSDK ver.{Version}")
        Console.WriteLine("**********************************************************************")
        Console.WriteLine("")
        Console.WriteLine("First, Please start Logging server.")
        Console.WriteLine("And next, press any key. (Press Esc key to exit this program.)")
        Console.WriteLine("Logging client will start.")
        Console.WriteLine("")

        ' Destination server information.
        Dim server = "localhost"
        Dim port = 50500

        ' API execution result.
        Dim result = FtsdkVBWrapper.FTCORE_RESULT.FTCORE_UNKNOWN_STATE

        ' Wait for key input.
        Dim keyinfo = New ConsoleKeyInfo()
        Console.WriteLine("> Wait for any key to be pressed ...")
        Console.Write("> ")
        keyinfo = Console.ReadKey()
        Console.WriteLine("")
        Console.WriteLine(System.String.Format("> {0} key was pressed.", keyinfo.Key))
        Select Case (keyinfo.Key)

                '//- Exit program -//
            Case ConsoleKey.Escape
                Exit Select

                '//- Startup Logging Client -//
            Case Else

                ' Loggin Client process start.
                Console.WriteLine("> Called FTCORE_StartProcess()..")
                result = FtsdkVBWrapper.FTCORE_StartProcess(server, port)

                Console.WriteLine("> result: {0}", result)
                Console.WriteLine("")
                Exit Select
        End Select

        If result = FtsdkVBWrapper.FTCORE_RESULT.FTCORE_SUCCESS Then

            '//- Directs loading of default category that stored in Logging Serever. -//

            ' Directs loading of default category.
            Console.WriteLine("> Called FTCORE_LoadDefaultCategory()..")
            result = FtsdkVBWrapper.FTCORE_LoadDefaultCategory()

            Console.WriteLine("> result: {0}", result)
            Console.WriteLine("")
        End If

        If result = FtsdkVBWrapper.FTCORE_RESULT.FTCORE_SUCCESS Then

            '//- Log out input keys -//

            Console.WriteLine("> Press any key then, Output log message.")
            Console.WriteLine("")

            keyinfo = New ConsoleKeyInfo()
            While keyinfo.Key <> ConsoleKey.Escape

                Console.Write("> ")
                keyinfo = Console.ReadKey()
                Console.Write(" key was pressed.")
                Console.WriteLine("")
                Dim logmsg = String.Format("{0} key was pressed.", keyinfo.Key.ToString())
                OutputLog(logmsg)

            End While

            '//- Exit program -//

            If keyinfo.Key = ConsoleKey.Escape Then

                ' Logging Client Exit process
                Console.WriteLine("> Called FTCORE_ExitProcess()..")
                result = FtsdkVBWrapper.FTCORE_ExitProcess()

                Console.WriteLine("> result: {0}", result)
                Console.WriteLine("")
            End If

        End If

        ' Press any key to exit program.
        Console.WriteLine("Press any key again to exit program.")
        Console.ReadKey()

    End Sub

    ''' <summary>
    ''' Log output
    ''' </summary>
    ''' <param name="message">Content of message.</param>
    Sub OutputLog(message As String)

        ' Random number generator.
        Dim rand = New System.Random()
        Dim index = 0

        ' Get caller method.
        Dim stack = New System.Diagnostics.StackFrame(1)
        Dim path = stack.GetMethod().ToString()

        ' Get log categories at random
        Dim categories = System.Enum.GetNames(GetType(DefaultCategory))
        index = rand.Next() Mod categories.Length
        Dim category = categories(index)

        ' Get log severity at random
        Dim severities = System.Enum.GetNames(GetType(Severity))
        index = rand.Next() Mod severities.Length
        Dim severity = severities(index)

        ' API execution
        Console.WriteLine("> Called FTCORE_SendMessage(...)")
        Dim result = FtsdkVBWrapper.FTCORE_SendMessage(path, category, severity, message)
        Console.WriteLine("> result: {0}" + System.Environment.NewLine, result)

    End Sub

    ''' <summary>
    ''' Get product version information.
    ''' </summary>
    ReadOnly Property ProductCopyright As System.String
        Get
            Dim assyname = System.Reflection.Assembly.GetExecutingAssembly().Location
            Return System.Diagnostics.FileVersionInfo.GetVersionInfo(assyname).LegalCopyright
        End Get
    End Property

    ''' <summary>
    ''' Get FTSDK version information.
    ''' </summary>
    ReadOnly Property FtsdkVersion As System.String
        Get
            Dim filename = AppDomain.CurrentDomain.BaseDirectory + "ft_cli.dll"
            Dim version = FileVersionInfo.GetVersionInfo(filename).FileVersion
            Return version
        End Get
    End Property

End Module
