//----------------------------------------------------------------------------------------------
// LoggingFoot FTSDK – Sample Program Using Node.js
//
// Demonstrates how to use LoggingFoot FTSDK via a Node.js wrapper.
// This sample program showcases usage of the following API:
//  - FTCORE_StartProcess
//  - FTCORE_StartTriggerWithParam
//  - FTCORE_StartTriggerWithSetup
//  - FTCORE_ExitProcess
//  - FTCORE_ExitTrigger
//  - FTCORE_SendMessage
//  - FTCORE_SetWindowState
//  - FTCORE_SetCustomCategory
//  - FTCORE_LoadDefaultCategory
//
// Copyright © 2025 Quantyworks Software
//----------------------------------------------------------------------------------------------
"use strict";

// To use FTSDK Wrapper for node-js.
const Wrapper = require('bindings')('addon');
const wrapper = new Wrapper();

// Encoding UTF-8 for node-js.
const encoding = require('encoding-japanese');

//----------------------------------------------------------------------------------------------
// LoggingFoot FTSDK – Sample Program Using Node.js
//
// Usage of FTCORE_StartProcess.
// Invoked from btnConnect_Click() in the front-end program.
//----------------------------------------------------------------------------------------------
exports.FTCORE_StartProcess = function(param){
    const server = param[0].split('=')[1];
    const portnumber = Number(param[1].split('=')[1]);

    // Call FTSDK-API.
    return wrapper.ftcoreStartProcess(server, portnumber);
}

//----------------------------------------------------------------------------------------------
// LoggingFoot FTSDK – Sample Program Using Node.js
//
// Usage of FTCORE_StartTriggerWithParam.
// Invoked from btnStartup_Click() in the front-end program.
//----------------------------------------------------------------------------------------------
exports.FTCORE_StartTriggerWithParam = function(param){
    const path = param[0].split('=')[1];
    const server = param[1].split('=')[1];
    const portnumber = Number(param[2].split('=')[1]);
    const windowstate = param[3].split('=')[1];
    const topmost = param[4].split('=')[1];

    let state = 0;
    switch(windowstate)
    {
        case 'SHOW_WINDOW_NORMALY': // Default
            state = 0;
            break;
        case 'SHOW_WINDOW_MAXIMIZE':// Maximized
            state = 1;
            break;
        case 'MINIMIZE_IN_TASKBAR':	// Minimized to the taskbar
            state = 2;
            break;
        case 'HIDE_IN_TASKTRAY':	// Hidden in the system tray
            state = 3;
            break;
        case 'WINDOW_HIDDEN':		// Fully hidden
            state = 4;
            break;
        default:
            state = 0;
            break;
    }

    let istopmost = 0;
    switch(topmost)
    {
        case 'FALSE':   // Topost is false (default)
            istopmost = 0;
            break;
        case 'TRUE':    // Topmost is true
            istopmost = 1;
            break;
        default:
            istopmost = 0;
            break;
    }
    
    // Call FTSDK-API.
    return wrapper.ftcoreStartTriggerWithParam(path, server, portnumber, state, istopmost);
}

//----------------------------------------------------------------------------------------------
// LoggingFoot FTSDK – Sample Program Using Node.js
//
// Usage of FTCORE_StartTriggerWithSetup.
// Invoked from btnStartup_Click() in the front-end program.
//----------------------------------------------------------------------------------------------
exports.FTCORE_StartTriggerWithSetup = function(param){
    const path = param[0].split('=')[1];
    const server = param[1].split('=')[1];
    const portnumber = Number(param[2].split('=')[1]);

    // Call FTSDK-API.
    return wrapper.ftcoreStartTriggerWithSetup(path, server, portnumber);
}

//----------------------------------------------------------------------------------------------
// LoggingFoot FTSDK – Sample Program Using Node.js
//
// Usage of FTCORE_ExitProcess.
// Invoked from btnDisconnect_Click() in the front-end program.
//----------------------------------------------------------------------------------------------
exports.FTCORE_ExitProcess = function(){

    // Call FTSDK-API.
    return wrapper.ftcoreExitProcess();
}

//----------------------------------------------------------------------------------------------
// LoggingFoot FTSDK – Sample Program Using Node.js
//
// Usage of FTCORE_ExitTrigger.
// Invoked from btnExit_Click() in the front-end program.
//----------------------------------------------------------------------------------------------
exports.FTCORE_ExitTrigger = function(){

    // Call FTSDK-API.
    return wrapper.ftcoreExitTrigger();
}

//----------------------------------------------------------------------------------------------
// LoggingFoot FTSDK – Sample Program Using Node.js
//
// Usage of FTCORE_SendMessage.
// Invoked from btnSend_Click() in the front-end program.
//----------------------------------------------------------------------------------------------
exports.FTCORE_SendMessage = function(param){
    const path = param[0].split('=')[1];
    const category = param[1].split('=')[1];
    const severity = param[2].split('=')[1];
    const message = param[3].split('=')[1];

    // Convert to UTF-8 code point for garbled characters.
    const defaultcode = encoding.stringToCode(message);
    const codeutf8 = encoding.convert(defaultcode, 'UTF8');

    // Call FTSDK-API.
    return wrapper.ftcoreSendMessage(path, category, severity, codeutf8);
}

//----------------------------------------------------------------------------------------------
// LoggingFoot FTSDK – Sample Program Using Node.js
//
// Usage of FTCORE_SetWindowState.
// Invoked from btnState_Click() in the front-end program.
//----------------------------------------------------------------------------------------------
exports.FTCORE_SetWindowState = function(param){
    const state = Number(param[0].split('=')[1]);

    // Call FTSDK-API.
    return wrapper.ftcoreSetWindowState(state);
}

//----------------------------------------------------------------------------------------------
// LoggingFoot FTSDK – Sample Program Using Node.js
//
// Usage of FTCORE_SetCustomCategory.
// Invoked from chkUseCustom_Click() in the front-end program.
//----------------------------------------------------------------------------------------------
exports.FTCORE_SetCustomCategory = function(param){
    const categories = param[0].split('=')[1];

    // Call FTSDK-API.
    return wrapper.ftcoreSetCustomCategory(categories);
}

//----------------------------------------------------------------------------------------------
// LoggingFoot FTSDK – Sample Program Using Node.js
//
// Usage of FTCORE_LoadDefaultCategory.
// Invoked from chkUseCustom_Click() in the front-end program.
//----------------------------------------------------------------------------------------------
exports.FTCORE_LoadDefaultCategory = function(param){

    // Call FTSDK-API.
    return wrapper.ftcoreLoadDefaultCategory();
}