#pragma once

#include "resource.h"

void OnInitDialog(HWND hdlg);
void OnExitDialog(HWND hdlg);

void OnButtonServerPathClick(HWND hdlg, int idc);
void OnButtonStartupClick(HWND hdlg, int idc);
void OnButtonExitClick(HWND hdlg, int idc);
void OnButtonSendClick(HWND hdlg, int idc);
void OnCheckRandCategoryClick(HWND hdlg, int idc, bool check);
void OnCheckRandSeverityClick(HWND hdlg, int idc, bool check);

inline void AddComboboxItem(HWND hcmb, char* item)
{
	::SendMessageA(hcmb, CB_ADDSTRING, 0, (LPARAM)item);
	::SendMessageA(hcmb, CB_SETCURSEL, 0, 0);
}
inline int GetComboboxItem(HWND hcb)
{
	return ::SendMessageA(hcb, CB_GETCURSEL, 0, 0);
}

inline bool GetCheckboxState(HWND hchk)
{
	int result = ::SendMessageA(hchk, BM_GETCHECK, 0, 0);
	return result == 0 ? false : true;
}

inline void ClickButton(HWND hdlg, int idc)
{
	switch (idc)
	{
		case IDC_BTN_SERVER_PATH:

			OnButtonServerPathClick(hdlg, idc);
			break;

		case IDC_BTN_STARTUP:

			OnButtonStartupClick(hdlg, idc);
			break;

		case IDC_BTN_EXIT:

			OnButtonExitClick(hdlg, idc);
			break;

		case IDC_BTN_SEND:
		
			OnButtonSendClick(hdlg, idc);
			break;

		case IDC_CHK_RND_CATEGORY:
		{
			bool check = GetCheckboxState(GetDlgItem(hdlg, idc));
			OnCheckRandCategoryClick(hdlg, idc, check);
			break;
		}
		
		case IDC_CHK_RND_SEVERITY:
		{
			bool check = GetCheckboxState(GetDlgItem(hdlg, idc));
			OnCheckRandSeverityClick(hdlg, idc, check);
			break;
		}
	}
}