﻿using FTSDK_Wrapper;
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Sample_SetCustomCategory
{
    class Program
    {
        /// <summary>
        /// Default category list.
        /// </summary>
        enum DefaultCategory
        {
            /// <summary>
            /// No categorized
            /// </summary>
            NON,
            /// <summary>
            /// Application
            /// </summary>
            APP,
            /// <summary>
            /// System
            /// </summary>
            SYSTEM,
            /// <summary>
            /// User operation
            /// </summary>
            USER,
            /// <summary>
            /// GUI operation
            /// </summary>
            UI,
            /// <summary>
            /// Work flow
            /// </summary>
            WF,
            /// <summary>
            /// Device
            /// </summary>
            DEVICE,
            /// <summary>
            /// Debug
            /// </summary>
            DEBUG,
            /// <summary>
            /// Step
            /// </summary>
            STEP,
            /// <summary>
            /// Event
            /// </summary>
            EVENT,
            /// <summary>
            /// Communication port
            /// </summary>
            COMM,
        }

        /// <summary>
        /// Custom category list.
        /// </summary>
        enum CustomCategory
        {
            /// <summary>
            /// No categorized
            /// </summary>
            NON,
            /// <summary>
            /// Application
            /// </summary>
            C_APP,
            /// <summary>
            /// System
            /// </summary>
            C_SYSTEM,
            /// <summary>
            /// User operation
            /// </summary>
            C_USER,
            /// <summary>
            /// GUI operation
            /// </summary>
            C_UI,
            /// <summary>
            /// Work flow
            /// </summary>
            C_WF,
            /// <summary>
            /// device
            /// </summary>
            C_DEVICE,
            /// <summary>
            /// Debug
            /// </summary>
            C_DEBUG,
            /// <summary>
            /// Step
            /// </summary>
            C_STEPLOG,
            /// <summary>
            /// Communication port
            /// </summary>
            C_COMM
        }

        /// <summary>
        /// Custom category list read from file
        /// </summary>
        enum FileCustomCategory
        {
            /// <summary>
            /// No categorized
            /// </summary>
            NON,
            /// <summary>
            /// Application
            /// </summary>
            F_APP,
            /// <summary>
            /// System
            /// </summary>
            F_SYSTEM,
            /// <summary>
            /// User operation
            /// </summary>
            F_USER,
            /// <summary>
            /// GUI operation
            /// </summary>
            F_UI,
            /// <summary>
            /// Work flow
            /// </summary>
            F_WF,
            /// <summary>
            /// device
            /// </summary>
            F_DEVICE,
            /// <summary>
            /// Debug
            /// </summary>
            F_DEBUG,
            /// <summary>
            /// Step
            /// </summary>
            F_STEPLOG,
            /// <summary>
            /// Communication port
            /// </summary>
            F_COMM
        }


        /// <summary>
        /// Logging severity list.
        /// </summary>
        enum Severity
        {
            /// <summary>
            /// No setting
            /// </summary>
            NON,
            /// <summary>
            /// Information
            /// </summary>
            INFO,
            /// <summary>
            /// Notice
            /// </summary>
            NOTICE,
            /// <summary>
            /// Warning
            /// </summary>
            WARNING,
            /// <summary>
            /// Normal error
            /// </summary>
            ERROR,
            /// <summary>
            /// Fatal error
            /// </summary>
            FATAL,
        }

        /// <summary>
        /// LoggingFoot sample program.
        /// How to use FTCORE_StartProcess and FTCORE_SetCustomCategory.
        /// </summary>
        static void Main()
        {
            // Get assembly information.
            var copyright = ProductCopyright;
            var version = FtsdkVersion;

            Console.WriteLine("**********************************************************************");
            Console.WriteLine("");
            Console.WriteLine("  LoggingFoot FTSDK sample program.");
            Console.WriteLine("  How to use FTCORE_StartProcess and FTCORE_SetCustomCategory.");
            Console.WriteLine("");
            Console.WriteLine($"  {copyright}");
            Console.WriteLine("");
            Console.WriteLine($"                                                  FTSDK ver.{version}");
            Console.WriteLine("**********************************************************************");
            Console.WriteLine("");
            Console.WriteLine("First, Please start the Logging server.");
            Console.WriteLine("And next, press any key. (Press Esc key to exit this program.)");
            Console.WriteLine("Logging client will start.");
            Console.WriteLine("");

            // Destination server information.
            var server = "localhost";
            var port = 50500;

            // API execution result.
            var result = FtsdkCSWrapper.FTCORE_RESULT.FTCORE_UNKNOWN_STATE;

            // Select category type
            // 0: default category
            // 1: custom category
            // 2: custom category read from file
            var categorytype = 0;

            // Wait for key input.
            var keyinfo = new ConsoleKeyInfo();
            Console.WriteLine("> Wait for any key to be pressed ...");
            Console.Write("> ");
            keyinfo = Console.ReadKey();
            Console.WriteLine("");
            Console.WriteLine(System.String.Format("> {0} key was pressed.", keyinfo.Key));
            switch (keyinfo.Key)
            {
                //- Exit program -//
                case ConsoleKey.Escape:
                    break;

                //- Startup Logging Client -//
                default:
                    
                    // Logging Client process start.
                    Console.WriteLine("> Called FTCORE_StartProcess()..");
                    result = FtsdkCSWrapper.FTCORE_StartProcess(server, port);

                    Console.WriteLine("> result: {0}", result);
                    Console.WriteLine("");
                    break;
            }

            if (result == FtsdkCSWrapper.FTCORE_RESULT.FTCORE_SUCCESS)
            {
                //- Select custom category setting API -//

                Console.WriteLine("> Press following number key, select API.");
                Console.WriteLine("> 0 : FTCORE_LoadDefaultCategory()");
                Console.WriteLine("> 1 : FTCORE_SetCustomCategory()");
                Console.WriteLine("> 2 : FTCORE_SetCustomCategoryFromFile()");
                Console.WriteLine("");

                keyinfo = new ConsoleKeyInfo();
                while (keyinfo.Key != ConsoleKey.Escape)
                {
                    //- Log out input keys -//

                    Console.Write("> ");
                    keyinfo = Console.ReadKey();
                    Console.Write(" key was pressed.");
                    Console.WriteLine("");
                    var logmsg = string.Format("{0} key was pressed.", keyinfo.Key.ToString());
                    OutputLog(logmsg, categorytype);

                    //- Call FTCORE_SetCustomCategory API -//

                    switch(keyinfo.Key)
                    {
                        case ConsoleKey.NumPad0:
                        case ConsoleKey.D0:

                            // Directs loading of default category that stored in the Logging Server.
                            {
                                categorytype = 0;
                                Console.WriteLine("> Called FTCORE_LoadDefaultCategory()..");
                                result = FtsdkCSWrapper.FTCORE_LoadDefaultCategory();

                                Console.WriteLine("> result: {0}", result);
                                Console.WriteLine("");
                            }
                            break;

                        case ConsoleKey.NumPad1:
                        case ConsoleKey.D1:

                            // Set the category defined in this program to the Logging Server.
                            {
                                // Concatenate category names separated by commas (with or without a comma at the end of the string).
                                categorytype = 1;
                                var enums = System.Enum.GetNames(typeof(CustomCategory));
                                var categories = default(string);
                                System.Array.ForEach(enums, category => categories += category + (","));

                                // Set to the Logging Server process.
                                Console.WriteLine("> Called FTCORE_SetCustomCategory()..");
                                result = FtsdkCSWrapper.FTCORE_SetCustomCategory(categories);

                                Console.WriteLine("> result: {0}", result);
                                Console.WriteLine("");
                            }
                            break;

                        case ConsoleKey.NumPad2:
                        case ConsoleKey.D2:

                            // Read the categories stored in the file and set them to the Logging Server.
                            {
                                categorytype = 2;
                                var file = ".\\CustomCategory_Sample.catdef";

                                // Set to the Logging Server process.
                                Console.WriteLine("> Called FTCORE_SetCustomCategoryFromFile()..");
                                result = FtsdkCSWrapper.FTCORE_SetCustomCategoryFromFile(file);

                                Console.WriteLine("> result: {0}", result);
                                Console.WriteLine("");
                            }
                            break;

                        case ConsoleKey.Escape:

                            // Logging Client exit process.
                            {
                                Console.WriteLine("> Called FTCORE_ExitProcess()..");
                                result = FtsdkCSWrapper.FTCORE_ExitProcess();

                                Console.WriteLine("> result: {0}", result);
                                Console.WriteLine("");
                            }
                            break;
                    }
                }
            }

            // Press any key to exit program.
            Console.WriteLine("Press any key again to exit program.");
            Console.ReadKey();
        }

        /// <summary>
        /// Outputs a log message.
        /// </summary>
        /// <param name="message">The content of the log message to be sent.</param>
        /// <param name="categorytype">Select category type</param>
        static void OutputLog(string message, int categorytype)
        {
            // Random number generator.
            var rand = new System.Random((int)System.DateTime.Now.Ticks);
            var index = 0;

            // Get caller method.
            var stack = new System.Diagnostics.StackFrame(1);
            var path = stack.GetMethod().ToString();

            // Select category type
            var categories = default(string[]);
            switch (categorytype)
            {
                case 0:
                    categories = System.Enum.GetNames(typeof(DefaultCategory));
                    break;
                case 1:
                    categories = System.Enum.GetNames(typeof(CustomCategory));
                    break;
                case 2:
                    categories = System.Enum.GetNames(typeof(FileCustomCategory));
                    break;
            }

            // Get log categories at random
            index = rand.Next() % categories.Length;
            var category = categories[index];

            // Get log severity at random.
            var severities = System.Enum.GetNames(typeof(Severity));
            index = rand.Next() % severities.Length;
            var severity = severities[index];

            // API execution
            Console.WriteLine("> Called FTCORE_SendMessage(...)");
            var result = FtsdkCSWrapper.FTCORE_SendMessage(path, category, severity, message);
            Console.WriteLine("> result: {0}\n", result);
        }

        /// <summary>
        /// Get product copyright information.
        /// </summary>
        static System.String ProductCopyright
        {
            get
            {
                var assyname = System.Reflection.Assembly.GetExecutingAssembly().Location;
                return System.Diagnostics.FileVersionInfo.GetVersionInfo(assyname).LegalCopyright;
            }
        }

        /// <summary>
        /// Get FTSDK version information.
        /// </summary>
        /// <returns></returns>
        static System.String FtsdkVersion
        {
            get
            {
                var filename = AppDomain.CurrentDomain.BaseDirectory + "ft_cli.dll";
                var version = FileVersionInfo.GetVersionInfo(filename).FileVersion;
                return version;
            }
        }
    }
}
